;----------------------------------------------------------------------
; Get some line number if we are dealing with RIP4 data
; This is to strip out all junk from the input data
;
; line_breaks will hold 3 pieces of information
;	number of junk header lines
; 	number of junk footer lines
; 	number of lines in file
;  
; This will be used the CreateTracks.csh to strip out unwanted information
;----------------------------------------------------------------------
undef("GetLineNums")
function GetLineNums(tkres)
begin

    if ( tkres@DataSource .eq. "RIP4" ) then
      filename = tkres@filename

      tester = (systemfunc("cut -c6-8 " + filename))

      line_breaks = new(3,integer)
      line_breaks    = 0
      line_breaks(2) = dimsizes(tester)
      do i =0,dimsizes(tester)-1
         if ( tester(i) .eq. "lat" .and. line_breaks(0) .ne. 0 ) then
           line_breaks(1) = i+1
           return (line_breaks)
         end if
         if ( tester(i) .eq. "   " .and. line_breaks(0) .ne. 0 ) then
           line_breaks(1) = i+1
           return (line_breaks)
         end if
         if ( tester(i) .eq. "lat" .and. line_breaks(0) .eq. 0 ) then
           line_breaks(0) = i+1
         end if
      end do

    end if

    return (line_breaks)

end
