;-----------------------------------------------------------------
; Make sure the final window is bigger than the data spread
;-----------------------------------------------------------------
undef("MapWindow")
procedure MapWindow(lat,lon,wnd,tkres)
begin

  do i=0,dimsizes(wnd)-1
    if ( wnd(i) .eq. -1.0 ) then
      lat(i) = 30.
      lon(i) = -80.
    end if
  end do
  min_lat = min(lat)
  max_lat = max(lat)
  min_lon = min(lon)
  max_lon = max(lon)

  if ( min_lat .lt. tkres@latMIN .and. .not. tkres@latMINset ) then
    min_lat = min_lat - tkres@disEDGE
  else
    min_lat = tkres@latMIN
  end if
  tkres@min_lat = min_lat

  if ( max_lat .gt. tkres@latMAX .and. .not. tkres@latMAXset ) then
    max_lat = max_lat + tkres@disEDGE
  else
    max_lat = tkres@latMAX
  end if
  tkres@max_lat = max_lat

  if ( min_lon .lt. tkres@lonMIN .and. .not. tkres@lonMINset ) then
    min_lon = min_lon - tkres@disEDGE
  else
    min_lon = tkres@lonMIN
  end if
  tkres@min_lon = min_lon

  if ( max_lon .gt. tkres@lonMAX .and. .not. tkres@lonMAXset ) then
    max_lon = max_lon + tkres@disEDGE
  else
    max_lon = tkres@lonMAX
  end if
  tkres@max_lon = max_lon

end


;-----------------------------------------------------------------
; Set up the basic map resources                             
;-----------------------------------------------------------------
undef("MapResources")
procedure MapResources(res,tkres)
begin

  res             = True

  res@gsnMaximize = True     ; Maximize plot size in the frame.
  res@gsnDraw     = False    ; Don't draw the plot just yet.
  res@gsnFrame    = False    ; Don't advance the frame just yet.

  res@pmTickMarkDisplayMode       = "Always"

  res@mpMinLatF                   =  tkres@min_lat
  res@mpMaxLatF                   =  tkres@max_lat
  res@mpMinLonF                   =  tkres@min_lon
  res@mpMaxLonF                   =  tkres@max_lon
  res@mpOutlineBoundarySets       = "GeophysicalAndUSStates"
  res@mpDataBaseVersion           = "MediumRes"
  res@mpFillColors                = (/"background","LightBlue","SandyBrown","LightBlue", \
                                      "transparent"/)
  res@mpGeophysicalLineColor      = "Azure4"
  res@mpGeophysicalLineThicknessF = 0.5
  res@mpGridLineColor             = "Azure4"
  res@mpGridLineThicknessF        = 0.5
  res@mpGridMaskMode              = 3
  res@mpGridSpacingF              = 5
  res@mpLimbLineColor             = "Azure4"
  res@mpLimbLineThicknessF        = 0.5
  res@mpNationalLineColor         = "Azure4"
  res@mpNationalLineThicknessF    = 0.5
  res@mpUSStateLineColor          = "Azure4"
  res@mpUSStateLineThicknessF     = 0.5
  res@mpGridAndLimbOn             = True
  res@mpOutlineOn                 = True

;
; Tickmark stuff.
;
  res@tmXBMajorOutwardLengthF     = 0.0
  res@tmXBMajorLengthF            = 0.0
  res@tmXBLabelFontHeightF    =     0.007

end
