
;   Script to produce plots for a WRF real-data run,
;   with the ARW coordinate dynamics option.

load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "WRFUserARW.ncl"

begin
;
; Make a list of all files we are interested in
  DATADir = "/ptmp/gill/global/WRFV2_top_parallel/test/em_real/"
  FILES = systemfunc ("csh -c ' ls " + DATADir + "wrfout* '")
  numFILES = dimsizes(FILES)
  print("numFILES = " + numFILES)
  print(FILES)
  print (" ")

; We generate plots, but what kind do we prefer?
  type = "x11"
  type = "pdf"
; type = "ps"
; type = "ncgm"
  wks = gsn_open_wks(type,"gwrf_061012_ps")

; What do we care to plot
  plotTER = True
  plotHPA = True
  plotPRE = True

; Interval to loop through the data
  timeINT = 10

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; The specific pressure levels that we want the data interpolated to.
  ;pressure_levels = (/ 850., 700., 500., 300./)   ; pressure levels to plot
  pressure_levels = (/ 500./)   ; pressure levels to plot
  nlevels         = dimsizes(pressure_levels)     ; number of pressure levels

; Let's set up all the basic plot resource we want to use
  resB = True
  resB@mpProjection         = "Stereographic"
  resB@mpEllipticalBoundary = True
  resB@mpFillOn = False
  resB@mpGeophysicalLineThicknessF = 2.0
  resB@gsnSpreadColors = True
  resB@gsnDraw = False    ; Make sure don't draw or frame or,
  resB@gsnFrame = False 
  resB@gsnMaximize = False
  resB@lbLabelJust = "BottomCenter"
  resB@lbLabelAutoStride = True
  resB@lbBoxMinorExtentF = 0.13
  resB@lbTitleJust = "BottomCenter"
  resB@lbTitleOffsetF = -0.4

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

FirstTime = True
do ifil = 0, numFILES-1      ; BIG FILES LOOP
   a = addfile(FILES(ifil)+".nc","r")
   print("Working on FILE: " +FILES(ifil) )

   ; What times and how many time steps are in this data set?
     times  = wrf_user_list_times(a)  ; get times in the file
     ntimes = dimsizes(times)         ; number of times in the file

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

     do it = 0,ntimes-1,timeINT              ; TIME LOOP

      print("Working on time: " + times(it) )
   
      if (FirstTime) then
        lat2T = a->XLAT(0,:,:)
        lon2T = a->XLONG(0,:,:)
        lat2U = a->XLAT_U(0,:,:)
        lon2U = a->XLONG_U(0,:,:)
   
        res = resB     ; Use for contours
        res@cnRasterModeOn = True
        res@cnFillOn = False
        res@sfXArray = lon2U
        res@sfYArray = lat2U
   
        resV = resB    ; Use for vectors
        resV@vfXArray = lon2T
        resV@vfYArray = lat2T
   
      end if
   
      res@gsnRightString = times(it)
      resV@gsnRightString = times(it)
   
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   
       if (plotTER .and. FirstTime) then
         ter = wrf_user_getvar(a,"HGT",it)
         opts = res
         opts@sfDataArray = ter
         opts@cnFillOn = True
         opts@cnLinesOn = False
         opts@cnLevelSelectionMode = "ExplicitLevels"
         opts@cnLevels             = (/ 0., 100., 200., 300., 400., 500., \
                                        1000., 1500., 2000., 2500., 3000.,\
                                        3500., 4000., 4500., 5000., 5500. /)
   
         opts@gsnLeftString = "Terrain Height (m)"
         opts@gsnRightString = " "
         opts@gsnPolar   = "SH"
         plot = gsn_csm_contour_map_polar(wks,ter,opts)
         draw(plot)
         frame(wks)
         opts@gsnPolar   = "NH"
         plot = gsn_csm_contour_map_polar(wks,ter,opts)
         draw(plot)
         frame(wks)
         delete(opts)
       end if
   
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   
       do pole = 0,1                 ; DO for both poles
   
         if ( pole .eq. 0 ) 
           res@gsnPolar   = "SH"
           resV@gsnPolar   = "SH"
         end if
         if ( pole .eq. 1 ) 
           res@gsnPolar   = "NH"
           resV@gsnPolar   = "NH"
         end if
    
   
         if (plotHPA) then
           do levs=0,nlevels-1

             pressure = pressure_levels(levs)
   
             tc  = wrf_user_getvar(a,"tc",it)        ; T in C
             rh  = wrf_user_getvar(a,"rh",it)        ; relative humidity
             z   = wrf_user_getvar(a, "z",it)        ; grid point height
             ua  = wrf_user_getvar(a,"ua",it)        ; u averaged to mass points
             va  = wrf_user_getvar(a,"va",it)        ; v averaged to mass points
             p   = wrf_user_getvar(a, "pressure",it) ; pressure 

             tc_plane = wrf_user_intrp3d(tc,p,"h",pressure,0.,False)
             rh_plane = wrf_user_intrp3d(rh,p,"h",pressure,0.,False)
             z_plane  = wrf_user_intrp3d( z,p,"h",pressure,0.,False)
             u_plane  = wrf_user_intrp3d(ua,p,"h",pressure,0.,False)
             v_plane  = wrf_user_intrp3d(va,p,"h",pressure,0.,False)
             spd     = (u_plane*u_plane + v_plane*v_plane)^(0.5) ; m/sec
             u_plane = u_plane*1.94386     ; kts
             v_plane = v_plane*1.94386     ; kts
   
   
             ; Plotting options for T                
               opts = res                          
               opts@sfDataArray = tc_plane
               opts@cnFillOn = True
               opts@cnLevelSelectionMode = "ManualLevels"
               opts@cnMinLevelValF       = -70.
               opts@cnMaxLevelValF       =  30.
               opts@cnLevelSpacingF      =  10.
               opts@cnLinesOn = False
               opts@gsnLeftString = " "
               opts@mpGeophysicalLineColor = "Brown"
               plot = gsn_csm_contour_map_polar(wks,tc_plane,opts)
               draw(plot)
               delete(opts)
       
       
             ; Plotting options for Geopotential Heigh
               opts = res                          
               opts@sfDataArray = z_plane
               opts@cnLevelSelectionMode = "ManualLevels"
               opts@cnMinLevelValF       = 4600.
               opts@cnMaxLevelValF       = 6100.
               opts@cnLevelSpacingF      =  100.
               ;opts@cnHighLabelsOn      = True
               ;opts@cnLowLabelsOn       = True
               opts@cnLineLabelsOn      = False
               opts@cnLineColor = "Black"
               opts@cnInfoLabelFontColor = opts@cnLineColor
               opts@cnInfoLabelPerimOn = False
               opts@cnInfoLabelString = z_plane@description + " Contours: $CMN$ to $CMX$ by $CIU$"
               opts@mpGeophysicalLineColor = "Brown"
               opts@gsnLeftString = " "
               opts@gsnContourLineThicknessesScale = 2.0
               plot = gsn_csm_contour_map_polar(wks,tc_plane,opts)
               draw(plot)
               delete(opts)
       
       
             ; Plotting options for Wind
               opts = resV                          
               opts@vfUDataArray = u_plane
               opts@vfVDataArray = v_plane
               opts@vcGlyphStyle = "WindBarb"
               opts@vcRefAnnoOn = False
               opts@vcMinDistanceF = 0.02
               opts@vcRefLengthF = 0.02
               opts@vcRefAnnoOrthogonalPosF = 0.03
               opts@vcRefAnnoParallelPosF = 0.09
               opts@vcWindBarbColor = "Black"
               opts@mpGeophysicalLineColor = "Brown"
               opts@gsnLeftString = tc_plane@description+ " (" +tc_plane@units+ ") at 500 hPa ~C~" +z_plane@description+ " (" +z_plane@units+ ") at 500 hPa ~C~Winds (kts) at 500 hPa"
               plot = gsn_csm_vector_map_polar(wks,u_plane,v_plane,opts)
               draw(plot)
               frame(wks)
               delete(opts)
       
             end do 
           end if ; plot levels
   
   
         if (plotPRE) then

           rain_exp = wrf_user_getvar(a,"RAINNC",it)
           rain_con = wrf_user_getvar(a,"RAINC",it)
           snow_exp = wrf_user_getvar(a,"SNOWNC",it)

           ; Plotting options for Precip
             opts = res                          
             opts@sfDataArray = rain_exp
             opts@cnFillOn = True
             opts@cnLinesOn = False
             opts@cnLevelSelectionMode = "ExplicitLevels"
             opts@cnLevels             = (/ .1, .2, .4, .8, 1.6, 3.2, 6.4, \
                                           12.8, 25.6, 51.2, 102.4/)
             opts@cnFillColors         = (/"White","White","DarkOliveGreen1", \
                                           "DarkOliveGreen3","Chartreuse", \
                                           "Chartreuse3","Green","ForestGreen", \
                                           "Yellow","Orange","Red","Violet"/)
             opts@gsnSpreadColors = False
             opts@gsnLeftString = " RAINNC (mm)"
             plot = gsn_csm_contour_map_polar(wks,rain_exp,opts)
             draw(plot)
             frame(wks)
             delete(opts@sfDataArray)
     
             opts@sfDataArray = rain_con
             opts@gsnLeftString = " RAINC (mm)"
             plot = gsn_csm_contour_map_polar(wks,rain_con,opts)
             draw(plot)
             frame(wks)
             delete(opts@sfDataArray)
       
             opts@sfDataArray = snow_exp
             opts@gsnLeftString = " SNOWNC (mm)"
             plot = gsn_csm_contour_map_polar(wks,snow_exp,opts)
             draw(plot)
             frame(wks)
             delete(opts)
    
          end if  ; End of Precipy options
     
       end do ; End of Polar options
     
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   
    FirstTime = False

  end do  ;       end of the time loop
end do  ;       end of BIG FILE LOOP

end
