    MODULE module_data_racm

! ****************************************************************

! Global Header File

! Generated by KPP - symbolic chemistry Kinetics PreProcessor
!     KPP is developed at CGRER labs University of Iowa by
!     Valeriu Damian & Adrian Sandu

! File                 : racm_kpp_seulex.h
! Time                 : Thu Apr 15 16:55:52 2004

! ****************************************************************

      IMPLICIT NONE

      REAL epsilc_racm
      PARAMETER (epsilc_racm=1.E-12)
! NPHOT - The number of photolytic reactions
      INTEGER nphot
      PARAMETER (nphot=23)

! NSPEC - The number of species involved
      INTEGER nspec

      PARAMETER (nspec=77)
! NVAR - The number of Variable species
      INTEGER nvar
      PARAMETER (nvar=73)
! NVARACT - The number of Active species
      INTEGER nvaract
      PARAMETER (nvaract=69)
! NRAD - The number of Radical species
      INTEGER nrad
      PARAMETER (nrad=1)
! NFIX - The number of Fixed species
      INTEGER nfix
      PARAMETER (nfix=4)
! NREACT - The number of reactions

      INTEGER nreact
      PARAMETER (nreact=237)
! NVARST - Starting of variables in conc. vect.
      INTEGER nvarst
      PARAMETER (nvarst=0)
! NRADST - Starting of radicals in conc. vect.
      INTEGER nradst

      PARAMETER (nradst=73)
! NFIXST - Starting of fixed in conc. vect.
      INTEGER nfixst
      PARAMETER (nfixst=73)
! NONZERO_V - Number of nonzero variable elements
      INTEGER nonzero_v
      PARAMETER (nonzero_v=925)
! LU_NONZERO_V - Number of nonzero variable LU elements
      INTEGER lu_nonzero_v
      PARAMETER (lu_nonzero_v=1051)
! NONZERO_R - Number of nonzero radical elements

      INTEGER nonzero_r
      PARAMETER (nonzero_r=0)
! CNVAR - (NVAR+1) The number of elements in compressed row format
      INTEGER cnvar
      PARAMETER (cnvar=nvar+1)
! CNRAD - (NRAD+1) The number of elements in compressed row format
      INTEGER cnrad
      PARAMETER (cnrad=nrad+1)
! NLOOKAT - number of species to look at
      INTEGER nlookat
      PARAMETER (nlookat=77)
! NMASS - number of atoms to check mass balance
      INTEGER nmass
      PARAMETER (nmass=0)
! NX - X grid dimension
      INTEGER nx
      PARAMETER (nx=0)
! NY - Y grid dimension
      INTEGER ny

      PARAMETER (ny=0)
! NZ - Z grid dimension
      INTEGER nz
      PARAMETER (nz=0)
! MAX_XYZ - maximum grid dimension
      INTEGER max_xyz
      PARAMETER (max_xyz=0)
! NS - number of species to transport
      INTEGER ns
      PARAMETER (ns=0)
! PI - Value of pi
      REAL*8 pi
      PARAMETER (pi=3.14159265358979)

! Declaration for global variables



! VAR - Concentrations of variable species (global)
      REAL*8 var(nvar)
! RAD - Concentrations of radical species (global)
      REAL*8 rad(nrad)
! FIX - Concentrations of fixed species (global)
      REAL*8 fix(nfix)
!RS      EQUIVALENCE (c(1+nvarst),var(1))
!RS      EQUIVALENCE (c(1+nradst),rad(1))
!RS      EQUIVALENCE (c(1+nfixst),fix(1))

!RS commonBs which have to be checked for WRF

!RS To be eliminated later
!RS
! TIME - current integration time
!RS      REAL*8 time
!RS      COMMON /gdata/time
! SUN - light intensity
!RS      REAL*8 sun
!RS      COMMON /gdata/sun
! C_DEFAULT - Default concentration for all species
!RS      REAL*8 c_default(nspec)
!RS      COMMON /gdata/c_default
! C - Concentration for all species
!RS      REAL*8 c(nspec)
!RS      COMMON /gdata/c
! TSTART - integration start time
!RS      REAL*8 tstart
!RS      COMMON /gdata/tstart
! TEND - integration end time
!RS      REAL*8 tend
!RS
!RS      COMMON /gdata/tend
! SMASS - names of atoms for mass balance
!RS      CHARACTER*12 smass(1)
!RS      COMMON /chargdata/smass
! TEMP - temperature
!     REAL*8 temp
!RS      COMMON /gdata/temp
! PRES -pressure
      REAL*8 pres
!RS      COMMON /gdata/pres
! DT - integration step

!RS      REAL*8 dt
!RS      COMMON /gdata/dt
! LOOKAT - indexes of species to look at
!RS      INTEGER lookat(77)
!RS      COMMON /intgdata/lookat

! SLOOKAT - names of species to look at
!RS      CHARACTER*12 slookat(77)
!RS      COMMON /chargdata/slookat
! NMONITOR - number of species to monitor
!RS      INTEGER nmonitor
!RS      PARAMETER (nmonitor=3)
! MONITOR - indexes of species to monitor
!RS      INTEGER monitor(3)
!RS      COMMON /intgdata/monitor
! SMONITOR - names of species to monitor

!RS      CHARACTER*12 smonitor(3)
!RS      COMMON /chargdata/smonitor




!RS COMMON blocks which ARE WRF compatible
! RTOLS - (scalar) relative tolerance
!RS      REAL*8 rtols
!RS      COMMON /gdata/rtols
! ATOL - Absolute tolerance
!RS      REAL*8 atol(nspec)
!RS      COMMON /gdata/atol
! RTOL - Relative tolerance
!RS      REAL*8 rtol(nspec)
!RS      COMMON /gdata/rtol
! STEPMIN - minimum allowed intergation step
      REAL*8 stepmin
!RS      COMMON /gdata/stepmin
! STEPMAX - maximum allowed integration step
      REAL*8 stepmax
!RS      COMMON /gdata/stepmax
! CFACTOR - Conversion factor
      REAL*8 cfactor
!RS      COMMON /gdata/cfactor
! TRANS - indexes of species to transport
!RS      INTEGER trans(1)
!RS      COMMON /intgdata/trans
! STRANS - names of species to transport
!RS      CHARACTER*12 strans(1)
!RS      COMMON /chargdata/strans
! SEQN - equation names
      CHARACTER*55 seqn(237)
!RS      COMMON /chargdata/seqn
      INTEGER isnotautonom
	

!RS END
! Indeces declaration for variable species

      INTEGER i_sulf
      PARAMETER (i_sulf=1)
      INTEGER i_co2
      PARAMETER (i_co2=2)
      INTEGER i_ora1
      PARAMETER (i_ora1=3)
      INTEGER i_ora2
      PARAMETER (i_ora2=4)
      INTEGER i_so2
      PARAMETER (i_so2=5)
      INTEGER i_o1d
      PARAMETER (i_o1d=6)
      INTEGER i_hc5
      PARAMETER (i_hc5=7)
      INTEGER i_tol
      PARAMETER (i_tol=8)
      INTEGER i_xyl
      PARAMETER (i_xyl=9)
      INTEGER i_n2o5
      PARAMETER (i_n2o5=10)
      INTEGER i_hc8
      PARAMETER (i_hc8=11)
      INTEGER i_hc3
      PARAMETER (i_hc3=12)
      INTEGER i_eth
      PARAMETER (i_eth=13)
      INTEGER i_ch4
      PARAMETER (i_ch4=14)
      INTEGER i_udd
      PARAMETER (i_udd=15)
      INTEGER i_hno4
      PARAMETER (i_hno4=16)
      INTEGER i_op1
      PARAMETER (i_op1=17)
      INTEGER i_hono
      PARAMETER (i_hono=18)
      INTEGER i_h2o2
      PARAMETER (i_h2o2=19)
      INTEGER i_pho
      PARAMETER (i_pho=20)
      INTEGER i_addt
      PARAMETER (i_addt=21)
      INTEGER i_addx
      PARAMETER (i_addx=22)
      INTEGER i_hket
      PARAMETER (i_hket=23)
      INTEGER i_ete
      PARAMETER (i_ete=24)
      INTEGER i_addc
      PARAMETER (i_addc=25)
      INTEGER i_paa
      PARAMETER (i_paa=26)
      INTEGER i_hno3
      PARAMETER (i_hno3=27)
      INTEGER i_co
      PARAMETER (i_co=28)
      INTEGER i_api
      PARAMETER (i_api=29)
      INTEGER i_lim
      PARAMETER (i_lim=30)
      INTEGER i_pan
      PARAMETER (i_pan=31)
      INTEGER i_csl
      PARAMETER (i_csl=32)
      INTEGER i_dien
      PARAMETER (i_dien=33)
      INTEGER i_gly
      PARAMETER (i_gly=34)
      INTEGER i_tpan
      PARAMETER (i_tpan=35)
      INTEGER i_etep
      PARAMETER (i_etep=36)

      INTEGER i_iso
      PARAMETER (i_iso=37)
      INTEGER i_oltp
      PARAMETER (i_oltp=38)
      INTEGER i_olip
      PARAMETER (i_olip=39)
      INTEGER i_mgly
      PARAMETER (i_mgly=40)
      INTEGER i_cslp
      PARAMETER (i_cslp=41)
      INTEGER i_ket
      PARAMETER (i_ket=42)
      INTEGER i_limp
      PARAMETER (i_limp=43)
      INTEGER i_hc5p
      PARAMETER (i_hc5p=44)
      INTEGER i_hc8p
      PARAMETER (i_hc8p=45)
      INTEGER i_tolp
      PARAMETER (i_tolp=46)
      INTEGER i_xylp
      PARAMETER (i_xylp=47)
      INTEGER i_hcho
      PARAMETER (i_hcho=48)
      INTEGER i_apip
      PARAMETER (i_apip=49)
      INTEGER i_isop
      PARAMETER (i_isop=50)
      INTEGER i_macr
      PARAMETER (i_macr=51)
      INTEGER i_hc3p
      PARAMETER (i_hc3p=52)
      INTEGER i_ald
      PARAMETER (i_ald=53)
      INTEGER i_dcb
      PARAMETER (i_dcb=54)
      INTEGER i_tco3
      PARAMETER (i_tco3=55)
      INTEGER i_xo2
      PARAMETER (i_xo2=56)
      INTEGER i_olt
      PARAMETER (i_olt=57)
      INTEGER i_oli
      PARAMETER (i_oli=58)
      INTEGER i_olnn
      PARAMETER (i_olnn=59)
      INTEGER i_olnd
      PARAMETER (i_olnd=60)
      INTEGER i_ethp
      PARAMETER (i_ethp=61)
      INTEGER i_o3p
      PARAMETER (i_o3p=62)
      INTEGER i_o3
      PARAMETER (i_o3=63)
      INTEGER i_ketp
      PARAMETER (i_ketp=64)
      INTEGER i_mo2
      PARAMETER (i_mo2=65)
      INTEGER i_aco3
      PARAMETER (i_aco3=66)
      INTEGER i_ho
      PARAMETER (i_ho=67)
      INTEGER i_onit
      PARAMETER (i_onit=68)
      INTEGER i_ho2

      PARAMETER (i_ho2=69)
      INTEGER i_no3
      PARAMETER (i_no3=70)
      INTEGER i_op2
      PARAMETER (i_op2=71)
      INTEGER i_no
      PARAMETER (i_no=72)
      INTEGER i_no2
      PARAMETER (i_no2=73)

! Indexes declaration for radical species
      INTEGER ir_addt
      PARAMETER (ir_addt=1)
      INTEGER ir_addx
      PARAMETER (ir_addx=2)
      INTEGER ir_addc
      PARAMETER (ir_addc=3)
      INTEGER ir_etep
      PARAMETER (ir_etep=4)
      INTEGER ir_oltp
      PARAMETER (ir_oltp=5)
      INTEGER ir_olip
      PARAMETER (ir_olip=6)
      INTEGER ir_cslp
      PARAMETER (ir_cslp=7)
      INTEGER ir_limp
      PARAMETER (ir_limp=8)
      INTEGER ir_hc5p
      PARAMETER (ir_hc5p=9)
      INTEGER ir_hc8p
      PARAMETER (ir_hc8p=10)
      INTEGER ir_tolp
      PARAMETER (ir_tolp=11)
      INTEGER ir_xylp
      PARAMETER (ir_xylp=12)
      INTEGER ir_apip
      PARAMETER (ir_apip=13)
      INTEGER ir_isop
      PARAMETER (ir_isop=14)
      INTEGER ir_hc3p

      PARAMETER (ir_hc3p=15)
      INTEGER ir_ethp
      PARAMETER (ir_ethp=16)
      INTEGER ir_o3p
      PARAMETER (ir_o3p=17)
      INTEGER ir_tco3
      PARAMETER (ir_tco3=18)
      INTEGER ir_mo2

      PARAMETER (ir_mo2=19)
      INTEGER ir_o1d
      PARAMETER (ir_o1d=20)
      INTEGER ir_olnn
      PARAMETER (ir_olnn=21)
      INTEGER ir_olnd
      PARAMETER (ir_olnd=22)
      INTEGER ir_rpho
      PARAMETER (ir_rpho=23)
      INTEGER ir_xo2
      PARAMETER (ir_xo2=24)
      INTEGER ir_ketp
      PARAMETER (ir_ketp=25)

! Indexes declaration for fixed species

      INTEGER i_h2o
      PARAMETER (i_h2o=1)
      INTEGER i_n2
      PARAMETER (i_n2=2)
      INTEGER i_o2
      PARAMETER (i_o2=3)
      INTEGER i_h2
      PARAMETER (i_h2=4)

! User defined variables


      REAL*8 stepstart
!RS      COMMON /gdata/stepstart

! End user defined variables

! ****************************************************************

! Sparse Data Header File

! Generated by KPP - symbolic chemistry Kinetics PreProcessor
!     KPP is developed at CGRER labs University of Iowa by
!     Valeriu Damian & Adrian Sandu


! File                 : racm_kpp_seulex_s.h
! Time                 : Thu Apr 15 16:55:52 2004
! Working directory    : /home/haas/Chemie/kpp_1.2/kpp-1.2/examples/racm
! Equation file        : racm_kpp_seulex.k
! Output root filename : racm_kpp_seulex

! ****************************************************************



! Sparse data

!RS! IROW_V - row indexes for the Jacobian of variables
!RS	 INTEGER irow_v(nonzero_v)
!RS	 COMMON /sdata/irow_v
!RS! ICOL_V - column indexes for the Jacobian of variables
!RS	 INTEGER icol_v(nonzero_v)
!RS	 COMMON /sdata/icol_v
!RS! CROW_V - compressed row indexes for the Jacobian of variables
!RS	 INTEGER crow_v(cnvar)
!RS	 COMMON /sdata/crow_v
!RS! DIAG_V - diagonal indexes for the Jacobian of variables
!RS	 INTEGER diag_v(cnvar)
!RS	 COMMON /sdata/diag_v
!RS! LU_IROW_V - row indexes for the LU Jacobian of variables
!RS	 INTEGER lu_irow_v(lu_nonzero_v)
!RS	 COMMON /sdata/lu_irow_v
!RS! LU_ICOL_V - column indexes for the LU Jacobian of variables
   	 INTEGER lu_icol_v(1051)
!RS 
!RS	 COMMON /sdata/lu_icol_v
!RS! LU_CROW_V - compressed row indexes for the LU Jacobian of variables
   	 INTEGER lu_crow_v(74)
!RS	 COMMON /sdata/lu_crow_v
!RS! LU_DIAG_V - diagonal indexes for the LU Jacobian of variables
   	 INTEGER lu_diag_v(74)
!RS	 COMMON /sdata/lu_diag_v
!RS! IROW_R - row indexes for the Jacobian of radicals
   	 INTEGER irow_r(nonzero_r+1)
!RS	 COMMON /sdata/irow_r
!RS! ICOL_R - column indexes for the Jacobian of radicals
   	 INTEGER icol_r(nonzero_r+1)
!RS	 COMMON /sdata/icol_r
!RS! CROW_R - compressed row indexes for the Jacobian of radicals
   	 INTEGER crow_r(cnrad)
!RS	 COMMON /sdata/crow_r
!RS! DIAG_R - diagonal indexes for the Jacobian of radicals
   	 INTEGER diag_r(cnrad)
!RS	 COMMON /sdata/diag_r


      INTEGER i

      DATA cfactor/1/


!RS	 DATA lookat/1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, &
!RS	   18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, &
!RS	   35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, &
!RS	   52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, &
!RS	   69, 70, 71, 72, 73, 74, 75, 76, 77/
!RS 
!RS 
!RS	 DATA slookat/'SULF', 'CO2', 'ORA1', 'ORA2', 'SO2', 'O1D', 'HC5', 'TOL', &
!RS	   'XYL', 'N2O5', 'HC8', 'HC3', 'ETH', 'CH4', 'UDD', 'HNO4', 'OP1', &
!RS	   'HONO', 'H2O2', 'PHO', 'ADDT', 'ADDX', 'HKET', 'ETE', 'ADDC', 'PAA', &
!RS	   'HNO3', 'CO', 'API', 'LIM', 'PAN', 'CSL', 'DIEN', 'GLY', 'TPAN', &
!RS	   'ETEP', 'ISO', 'OLTP', 'OLIP', 'MGLY', 'CSLP', 'KET', 'LIMP', 'HC5P', &
!RS	   'HC8P', 'TOLP', 'XYLP', 'HCHO', 'APIP', 'ISOP', 'MACR', 'HC3P', 'ALD', &
!RS	   'DCB', 'TCO3', 'XO2', 'OLT', 'OLI', 'OLNN', 'OLND', 'ETHP', 'O3P', &
!RS	   'O3', 'KETP', 'MO2', 'ACO3', 'HO', 'ONIT', 'HO2', 'NO3', 'OP2', 'NO', &
!RS	   'NO2', 'H2O', 'N2', 'O2', 'H2'/


!RS     DATA monitor/63, 72, 73/


!RS     DATA smonitor/'O3', 'NO', 'NO2'/





      DATA (seqn(i),i=1,24)/'                             NO2 --> O3P + NO   ' &
        , '                              O3 --> O1D + O2   ', &
        '                              O3 --> O3P + O2   ', &
        '                            HONO --> HO + NO    ', &
        '                            HNO3 --> HO + NO2   ', &
        '               HNO4 --> 0HO + 1HO2 + 0NO3 + 1NO2', &
        '                             NO3 --> NO + O2    ', &
        '                             NO3 --> O3P + NO2  ', &
        '                            H2O2 --> 2HO        ', &
        '                            HCHO --> CO + H2    ', &
        '                            HCHO --> CO + 2HO2  ', &
        '                          ALD --> CO + MO2 + HO2', &
        '                         OP1 --> HCHO + HO + HO2', &
        '                          OP2 --> ALD + HO + HO2', &
        '                             PAA --> MO2 + HO   ', &
        '                             KET --> ETHP + ACO3', &
        '                       GLY --> 2CO + 0HCHO + 1H2', &
        '                GLY --> 2CO + 0HCHO + 1HO2 + 0H2', &
        '                        MGLY --> CO + ACO3 + HO2', &
        '                             DCB --> TCO3 + HO2 ', &
        '                ONIT --> 1KET + 0ALD + HO2 + NO2', &
        '                 MACR --> CO + HCHO + ACO3 + HO2', &
        '                      HKET --> HCHO + ACO3 + HO2', &
        '                        O3P + O2 --> O3         '/

      DATA (seqn(i),i=25,48)/ &
        '                        O3P + O3 --> 2O2        ', &
        '                        O1D + N2 --> O3P + N2   ', &
        '                        O1D + O2 --> O3P + O2   ', &
        '                       O1D + H2O --> 2HO        ', &
        '                         O3 + HO --> HO2 + O2   ', &
        '                        O3 + HO2 --> HO + 2O2   ', &
        '                        HO + HO2 --> H2O + O2   ', &
        '                       H2O2 + HO --> HO2 + H2O  ', &
        '                            2HO2 --> H2O2 + O2  ', &
        '                  2HO2 + H2O --> H2O2 + H2O + O2', &
        '                        O3P + NO --> NO2        ', &
        '                       O3P + NO2 --> NO + O2    ', &
        '                       O3P + NO2 --> NO3        ', &
        '                         HO + NO --> HONO       ', &
        '                        HO + NO2 --> HNO3       ', &
        '                        HO + NO3 --> HO2 + NO2  ', &
        '                        HO2 + NO --> HO + NO2   ', &
        '                       HO2 + NO2 --> HNO4       ', &
        '                            HNO4 --> HO2 + NO2  ', &
        '           HO2 + NO3 --> 0HNO3 + 1HO + 1NO2 + O2', &
        '                       HONO + HO --> NO2 + H2O  ', &
        '                       HNO3 + HO --> NO3 + H2O  ', &
        '                    HNO4 + HO --> NO2 + H2O + O2', &
        '                         O3 + NO --> NO2 + O2   '/

      DATA (seqn(i),i=49,72)/ &
        '                        O3 + NO2 --> NO3 + O2   ', &
        '                        2NO + O2 --> 2NO2       ', &
        '                        NO3 + NO --> 2NO2       ', &
        '                     NO3 + NO2 --> NO + NO2 + O2', &
        '                       NO3 + NO2 --> N2O5       ', &
        '                            N2O5 --> NO3 + NO2  ', &
        '                            2NO3 --> 2NO2 + O2  ', &
        '                         HO + H2 --> HO2 + H2O  ', &
        '                        SO2 + HO --> SULF + HO2 ', &
        '                         CO + HO --> CO2 + HO2  ', &
        '  ISO + O3P --> 0CO + 0HCHO + 0DCB + 0XO2 + 1OLT + 0HO', &
        '                      MACR + O3P --> ALD        ', &
        '                        CH4 + HO --> MO2 + H2O  ', &
        '                        ETH + HO --> ETHP + H2O ', &
        '   HC3 + HO --> 0ORA1 + 0CO + 0GLY + 0HCHO + 1HC3P + 0', &
        '          HC5 + HO --> 0KET + 1HC5P + 0HO2 + H2O', &
        '   HC8 + HO --> 0HKET + 1HC8P + 0ALD + 0HO2 + H2O', &
        '                        ETE + HO --> ETEP       ', &
        '                        OLT + HO --> OLTP       ', &
        '                        OLI + HO --> OLIP       ', &
        '                       DIEN + HO --> ISOP       ', &
        '                        ISO + HO --> ISOP       ', &
        '                        API + HO --> APIP       ', &
        '                        LIM + HO --> LIMP       '/

      DATA (seqn(i),i=73,96)/ &
        '                TOL + HO --> 1ADDT + 0XO2 + 0HO2', &
        '                XYL + HO --> 1ADDX + 0XO2 + 0HO2', &
        '         CSL + HO --> 0PHO + 1ADDC + 0XO2 + 0HO2', &
        '                    HCHO + HO --> CO + HO2 + H2O', &
        '                        ALD + HO --> ACO3 + H2O ', &
        '                        KET + HO --> KETP + H2O ', &
        '                  HKET + HO --> MGLY + HO2 + H2O', &
        '                    GLY + HO --> 2CO + HO2 + H2O', &
        '                   MGLY + HO --> CO + ACO3 + H2O', &
        '  MACR + HO --> 0HKET + 0CO + 0MGLY + 0HCHO + 1TCO3 + ', &
        '   DCB + HO --> 0UDD + 0GLY + 0MGLY + 0TCO3 + 0XO2 + 0', &
        '                  UDD + HO --> 0KET + 1ALD + HO2', &
        '                 OP1 + HO --> 0HCHO + 1MO2 + 0HO', &
        '   HO + OP2 --> 0KET + 0HC3P + 0ALD + 0XO2 + 0HO', &
        '        PAA + HO --> 0HCHO + 0XO2 + 1ACO3 + 0HO2', &
        '             PAN + HO --> HCHO + XO2 + NO3 + H2O', &
        '  TPAN + HO --> 1HKET + 0PAN + 0HCHO + XO2 + 0HO2 + 1N', &
        '                  HO + ONIT --> HC3P + NO2 + H2O', &
        '                  HCHO + NO3 --> HNO3 + CO + HO2', &
        '                       ALD + NO3 --> HNO3 + ACO3', &
        '                  GLY + NO3 --> HNO3 + 2CO + HO2', &
        '                 MGLY + NO3 --> HNO3 + CO + ACO3', &
        '      MACR + NO3 --> 0HNO3 + 1CO + 0TCO3 + 1OLNN', &
        '  DCB + NO3 --> 0HNO3 + 0GLY + 0MGLY + 0KET + 0ALD + 0'/


      DATA (seqn(i),i=97,120)/ &
        '                       CSL + NO3 --> PHO + HNO3 ', &
        '                     ETE + NO3 --> 1OLNN + 0OLND', &
        '                     OLT + NO3 --> 0OLNN + 1OLND', &
        '                     OLI + NO3 --> 0OLNN + 1OLND', &
        '            DIEN + NO3 --> 1MACR + 1OLNN + 0OLND', &
        '             ISO + NO3 --> 1MACR + 1OLNN + 0OLND', &
        '                     API + NO3 --> 0OLNN + 1OLND', &
        '                     LIM + NO3 --> 0OLNN + 1OLND', &
        ' TPAN + NO3 --> 0PAN + 0HCHO + XO2 + 1ONIT + 1NO3 + 0N', &
        '   ETE + O3 --> 0ORA1 + 0CO + HCHO + 0HO + 0HO2 + 0H2', &
        '   OLT + O3 --> 0ORA1 + 0ORA2 + 0ETH + 0CH4 + 0H2O2 + ', &
        '   OLI + O3 --> 0ORA2 + 0ETH + 0CH4 + 0H2O2 + 0CO + 0K', &
        '  DIEN + O3 --> 0ORA1 + 0H2O2 + 0CO + 1HCHO + 0MACR + ', &
        '   ISO + O3 --> 0ORA1 + 0H2O2 + 0CO + 1HCHO + 0MACR + ', &
        '   API + O3 --> 0H2O2 + 0CO + 1KET + 1ALD + 0ETHP + 0K', &
        '   LIM + O3 --> 0ORA1 + 0ORA2 + 0H2O2 + 0CO + 0HCHO + ', &
        '  MACR + O3 --> 0ORA1 + 0ORA2 + 1CO + 1MGLY + 0HCHO + ', &
        '   DCB + O3 --> 0ORA1 + 0ORA2 + 0PAA + 1CO + 0GLY + 1M', &
        '  TPAN + O3 --> 0ORA1 + 0CO + 0PAN + 1HCHO + 1ACO3 + 0', &
        '                       PHO + NO2 --> 0CSL + ONIT', &
        '                       PHO + HO2 --> CSL        ', &
        '                      ADDT + NO2 --> HONO + CSL ', &
        '               ADDT + O2 --> 0CSL + 1TOLP + 0HO2', &
        '                       ADDT + O3 --> CSL + HO   '/

      DATA (seqn(i),i=121,144)/ &
        '                      ADDX + NO2 --> HONO + CSL ', &
        '               ADDX + O2 --> 0CSL + 1XYLP + 0HO2', &
        '                       ADDX + O3 --> CSL + HO   ', &
        '                      ADDC + NO2 --> HONO + CSL ', & 
        '               ADDC + O2 --> 0CSL + 1CSLP + 0HO2', &
        '                       ADDC + O3 --> CSL + HO   ', &
        '                      ACO3 + NO2 --> PAN        ', &
        '                             PAN --> ACO3 + NO2 ', &
        '                      TCO3 + NO2 --> TPAN       ', &
        '                            TPAN --> TCO3 + NO2 ', &
        '                   MO2 + NO --> HCHO + HO2 + NO2', &
        '                   ETHP + NO --> ALD + HO2 + NO2', &
        '  HC3P + NO --> 0GLY + 1KET + 0HCHO + 0ALD + 0XO2 + 0E', &
        '  HC5P + NO --> 1KET + 0HCHO + 0ALD + 0XO2 + 0ETHP + 0', &
        '  HC8P + NO --> 1KET + 0ALD + 0XO2 + 0ETHP + 0ONIT + 1', &
        '          ETEP + NO --> 2HCHO + 0ALD + HO2 + NO2', &
        '    OLTP + NO --> 0KET + HCHO + 1ALD + HO2 + NO2', &
        '           OLIP + NO --> 0KET + 2ALD + HO2 + NO2', &
        '  ISOP + NO --> 1HCHO + 0MACR + 0OLT + 0ONIT + 1HO2 + ', &
        '  APIP + NO --> 1KET + 1ALD + 0ONIT + 1HO2 + 1NO2', &
        '  LIMP + NO --> 0HCHO + 0MACR + 0OLI + 0ONIT + 1HO2 + ', &
        '  TOLP + NO --> 1GLY + 1MGLY + 0DCB + 0ONIT + 1HO2 + 1', &
        '  XYLP + NO --> 0GLY + 1MGLY + 1DCB + 0ONIT + 1HO2 + 1', &
        '            CSLP + NO --> GLY + MGLY + HO2 + NO2'/

      DATA (seqn(i),i=145,168)/ &
        '                       ACO3 + NO --> MO2 + NO2  ', &
        '                 TCO3 + NO --> HCHO + ACO3 + NO2', &
        '  KETP + NO --> 1MGLY + 0ALD + 0XO2 + 0ACO3 + 1HO2 + N', &
        '                  OLNN + NO --> ONIT + HO2 + NO2', &
        '        OLND + NO --> 0KET + 0HCHO + 1ALD + 2NO2', &
        '                       MO2 + HO2 --> OP1        ', &
        '                      ETHP + HO2 --> OP2        ', &
        '                      HC3P + HO2 --> OP2        ', &
        '                      HC5P + HO2 --> OP2        ', &
        '                      HC8P + HO2 --> OP2        ', &
        '                      ETEP + HO2 --> OP2        ', &
        '                      OLTP + HO2 --> OP2        ', &
        '                      OLIP + HO2 --> OP2        ', &
        '                      ISOP + HO2 --> OP2        ', &
        '                      APIP + HO2 --> OP2        ', &
        '                      LIMP + HO2 --> OP2        ', &
        '                      TOLP + HO2 --> OP2        ', &
        '                      XYLP + HO2 --> OP2        ', &
        '                      CSLP + HO2 --> OP2        ', &
        '                      ACO3 + HO2 --> PAA        ', &
        '                      ACO3 + HO2 --> ORA2 + O3  ', &
        '                      TCO3 + HO2 --> OP2        ', &
        '                      TCO3 + HO2 --> ORA2 + O3  ', &
        '                      KETP + HO2 --> OP2        '/

      DATA (seqn(i),i=169,192)/ &
        '                      OLNN + HO2 --> ONIT       ', & 
        '                      OLND + HO2 --> ONIT       ', &
        '                           2MO2 --> 1HCHO + 1HO2', &
        '               ETHP + MO2 --> 1HCHO + 1ALD + HO2', &
        ' HC3P + MO2 --> 0GLY + 0MGLY + 0KET + 1HCHO + 1ALD + 0', &
        ' HC5P + MO2 --> 0KET + 1HCHO + 1ALD + 0XO2 + 0ETHP + 0', &
        ' HC8P + MO2 --> 0KET + 1HCHO + 0ALD + 0XO2 + 0ETHP + 1', &
        '               ETEP + MO2 --> 2HCHO + 0ALD + HO2', &
        '        OLTP + MO2 --> 0KET + 1HCHO + 1ALD + HO2', &
        '        OLIP + MO2 --> 0KET + 1HCHO + 1ALD + HO2', &
        ' ISOP + MO2 --> 1HCHO + 1MACR + 0OLT + 0OLI + HO2', &
        '          APIP + MO2 --> KET + HCHO + ALD + 2HO2', &
        '      LIMP + MO2 --> 1HCHO + 1MACR + 0OLI + 2HO2', &
        '  TOLP + MO2 --> 1GLY + 0MGLY + HCHO + DCB + HO2', &
        '  XYLP + MO2 --> 0GLY + 1MGLY + HCHO + DCB + HO2', &
        '         CSLP + MO2 --> GLY + MGLY + HCHO + 2HO2', &
        '                 MO2 + ACO3 --> HCHO + MO2 + HO2', &
        '                      MO2 + ACO3 --> ORA2 + HCHO', &
        '               TCO3 + MO2 --> 2HCHO + ACO3 + HO2', &
        '                      TCO3 + MO2 --> ORA2 + HCHO', &
        ' KETP + MO2 --> 0HKET + 0MGLY + 1HCHO + 0ALD + 0XO2 + ', &
        '               OLNN + MO2 --> 1HCHO + ONIT + HO2', &
        ' OLND + MO2 --> 0KET + 1HCHO + 1ALD + 0ONIT + 0HO2 + 0', &
        '       ETHP + ACO3 --> 0ORA2 + ALD + 0MO2 + 0HO2'/

      DATA (seqn(i),i=193,216)/ &
        'HC3P + ACO3 --> 0ORA2 + 0GLY + 0MGLY + 0KET + 0HCHO + ', &
        'HC5P + ACO3 --> 0ORA2 + 0KET + 0HCHO + 1ALD + 0XO2 + 0', &
        'HC8P + ACO3 --> 0ORA2 + 1KET + 0ALD + 0XO2 + 0ETHP + 1', &
        'ETEP + ACO3 --> 0ORA2 + 1HCHO + 1ALD + 0MO2 + 0HO2', &
        'OLTP + ACO3 --> 0ORA2 + 0KET + 1HCHO + 1ALD + 1MO2 + 1', &
        'OLIP + ACO3 --> 0ORA2 + 1KET + 1ALD + 1MO2 + 1HO2', &
        'ISOP + ACO3 --> 0ORA2 + 0HCHO + 1MACR + 0OLT + 1MO2 + ', &
        '           APIP + ACO3 --> KET + ALD + MO2 + HO2', &
        'LIMP + ACO3 --> 0HCHO + 1MACR + 0OLI + MO2 + HO2', &
        '  TOLP + ACO3 --> 1GLY + 0MGLY + DCB + MO2 + HO2', &
        '  XYLP + ACO3 --> 0GLY + 1MGLY + DCB + MO2 + HO2', &
        '          CSLP + ACO3 --> GLY + MGLY + MO2 + HO2', &
        '                           2ACO3 --> 2MO2       ', &
        '               TCO3 + ACO3 --> HCHO + MO2 + ACO3', &
        'KETP + ACO3 --> 0ORA2 + 1MGLY + 0KET + 0ALD + 0XO2 + 0', &
        '      OLNN + ACO3 --> 0ORA2 + 0MO2 + ONIT + 0HO2', &
        'OLND + ACO3 --> 0ORA2 + 0KET + 0HCHO + 1ALD + 1MO2 + 0', &
        '                           2OLNN --> 2ONIT + HO2', &
        'OLNN + OLND --> 0KET + 0HCHO + 1ALD + 2ONIT + 0HO2 + 0', &
        '      2OLND --> 0KET + 1HCHO + 1ALD + ONIT + NO2', &
        '                  MO2 + NO3 --> HCHO + HO2 + NO2', &
        '                  ETHP + NO3 --> ALD + HO2 + NO2', &
        ' HC3P + NO3 --> 0GLY + 1KET + 0HCHO + 0ALD + 0XO2 + 0E', &
        ' HC5P + NO3 --> 1KET + 0HCHO + 0ALD + 0XO2 + 0ETHP + 0'/

      DATA (seqn(i),i=217,237)/ &
        ' HC8P + NO3 --> 1KET + 0ALD + 1XO2 + 0ETHP + 1HO2 + NO', &
        '         ETEP + NO3 --> 2HCHO + 0ALD + HO2 + NO2', &
        '   OLTP + NO3 --> 0KET + HCHO + 1ALD + HO2 + NO2', &
        '          OLIP + NO3 --> 0KET + 2ALD + HO2 + NO2', & 
        ' ISOP + NO3 --> 1HCHO + 1MACR + 0OLT + HO2 + NO2', &
        '            APIP + NO3 --> KET + ALD + HO2 + NO2', &
        ' LIMP + NO3 --> 0HCHO + 1MACR + 0OLI + HO2 + NO2', &
        '  TOLP + NO3 --> 1GLY + 1MGLY + 0DCB + HO2 + NO2', &
        '   XYLP + NO3 --> 1GLY + 1MGLY + DCB + HO2 + NO2', &
        '           CSLP + NO3 --> GLY + MGLY + HO2 + NO2', &
        '                      ACO3 + NO3 --> MO2 + NO2  ', &
        '                TCO3 + NO3 --> HCHO + ACO3 + NO2', &
        ' KETP + NO3 --> 1MGLY + 0ALD + 0XO2 + 0ACO3 + 1HO2 + N', &
        '                 OLNN + NO3 --> ONIT + HO2 + NO2', &
        '       OLND + NO3 --> 0KET + 0HCHO + 1ALD + 2NO2', &
        '                       XO2 + HO2 --> OP2        ', &
        '                       XO2 + MO2 --> HCHO + HO2 ', &
        '                      XO2 + ACO3 --> MO2        ', &
        '                            2XO2 --> O2         ', &
        '                        XO2 + NO --> NO2        ', &
        '                       XO2 + NO3 --> NO2        '/




      DATA (lu_icol_v(i),i=1,252)/1, 5, 67, 2, 28, 67, 3, 12, 24, 30, 33, 35, &
        37, 51, 54, 57, 63, 67, 4, 30, 36, 38, 39, 44, 45, 50, 51, 52, 54, 55, &
        57, 58, 59, 60, 61, 63, 64, 65, 66, 69, 5, 67, 6, 63, 7, 67, 8, 67, 9, &
        67, 10, 70, 73, 11, 67, 12, 67, 13, 57, 58, 63, 67, 14, 57, 58, 63, &
        67, 15, 54, 67, 16, 67, 69, 73, 17, 65, 67, 69, 18, 21, 22, 25, 67, &
        72, 73, 19, 29, 30, 33, 37, 57, 58, 63, 67, 69, 20, 32, 67, 69, 70, &
        73, 8, 21, 63, 67, 73, 9, 22, 63, 67, 73, 11, 23, 35, 51, 64, 65, 67, &
        24, 63, 67, 70, 25, 32, 63, 67, 73, 26, 54, 63, 66, 67, 69, 27, 32, &
        34, 40, 48, 51, 53, 54, 67, 69, 70, 73, 12, 24, 28, 29, 30, 33, 34, &
        35, 37, 40, 48, 51, 53, 54, 57, 58, 62, 63, 67, 70, 29, 63, 67, 70, &
        30, 63, 67, 70, 31, 35, 63, 66, 67, 70, 73, 20, 21, 22, 25, 32, 63, &
        67, 69, 70, 73, 33, 63, 67, 70, 12, 34, 41, 46, 47, 52, 54, 63, 65, &
        66, 67, 70, 72, 35, 55, 63, 67, 70, 73, 24, 36, 63, 65, 66, 67, 69, &
        70, 72, 37, 62, 63, 67, 70, 38, 57, 65, 66, 67, 69, 70, 72, 39, 58, &
        65, 66, 67, 69, 70, 72, 23, 35, 40, 41, 46, 47, 51, 52, 54/

      DATA (lu_icol_v(i),i=253,504)/55, 63, 64, 65, 66, 67, 70, 72, 73, 25, &
        32, 41, 63, 65, 66, 67, 69, 70, 72, 73, 7, 15, 29, 38, 39, 42, 44, 45, &
        49, 52, 54, 57, 58, 59, 60, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, &
        30, 43, 63, 65, 66, 67, 69, 70, 72, 7, 44, 65, 66, 67, 69, 70, 72, 11, &
        45, 65, 66, 67, 69, 70, 72, 21, 46, 63, 65, 66, 67, 69, 70, 72, 73, &
        22, 47, 63, 65, 66, 67, 69, 70, 72, 73, 12, 17, 23, 24, 26, 30, 31, &
        33, 34, 35, 36, 37, 38, 39, 41, 43, 44, 45, 46, 47, 48, 49, 50, 51, &
        52, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 69, 70, &
        72, 73, 29, 49, 63, 65, 66, 67, 69, 70, 72, 33, 37, 50, 62, 63, 65, &
        66, 67, 69, 70, 72, 30, 33, 37, 43, 50, 51, 62, 63, 65, 66, 67, 69, &
        70, 72, 12, 52, 65, 66, 67, 68, 69, 70, 71, 72, 11, 12, 15, 29, 36, &
        38, 39, 44, 45, 49, 51, 52, 53, 54, 57, 58, 59, 60, 61, 62, 63, 64, &
        65, 66, 67, 68, 69, 70, 71, 72, 37, 46, 47, 54, 62, 63, 65, 66, 67, &
        69, 70, 72, 73, 35, 51, 54, 55, 62, 63, 65, 66, 67, 69, 70, 72, 73, 8, &
        9, 26, 31, 32, 33, 35, 37, 44, 45, 51, 52, 54, 55, 56, 62, 63, 64, 65/

      DATA (lu_icol_v(i),i=505,756)/66, 67, 68, 69, 70, 71, 72, 73, 30, 33, &
        37, 50, 57, 62, 63, 65, 66, 67, 69, 70, 72, 43, 50, 58, 62, 63, 65, &
        66, 67, 69, 70, 72, 24, 29, 30, 33, 37, 51, 57, 58, 59, 60, 62, 63, &
        65, 66, 67, 69, 70, 72, 24, 29, 30, 33, 37, 57, 58, 59, 60, 62, 63, &
        65, 66, 67, 69, 70, 72, 13, 29, 30, 42, 44, 45, 49, 52, 54, 57, 58, &
        59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 6, 33, 37, &
        51, 62, 63, 65, 66, 67, 69, 70, 72, 73, 21, 22, 24, 25, 29, 30, 32, &
        33, 35, 37, 51, 54, 55, 57, 58, 62, 63, 65, 66, 67, 69, 70, 72, 73, &
        29, 30, 33, 37, 42, 44, 45, 49, 52, 54, 57, 58, 59, 60, 62, 63, 64, &
        65, 66, 67, 68, 69, 70, 71, 72, 73, 14, 17, 26, 33, 36, 37, 38, 39, &
        41, 43, 44, 45, 46, 47, 49, 50, 52, 53, 54, 55, 56, 57, 58, 59, 60, &
        61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 23, 26, 31, 33, &
        35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 49, 50, 51, 52, &
        53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, &
        70, 71, 72, 73, 5, 6, 7, 8, 9, 11, 12, 13, 14, 15, 16, 17, 18, 19, 21, &
        22/

      DATA (lu_icol_v(i),i=757,1008)/23, 24, 25, 26, 27, 28, 29, 30, 31, 32, &
        33, 34, 35, 37, 40, 41, 42, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, &
        54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, &
        71, 72, 73, 20, 32, 35, 43, 44, 45, 46, 47, 49, 50, 52, 55, 59, 60, &
        62, 63, 65, 66, 67, 68, 69, 70, 71, 72, 73, 5, 7, 8, 9, 11, 12, 15, &
        16, 17, 19, 20, 21, 22, 23, 24, 25, 26, 28, 29, 30, 32, 33, 34, 35, &
        36, 37, 38, 39, 40, 41, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, &
        54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, &
        71, 72, 73, 10, 16, 24, 27, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, &
        39, 40, 41, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, &
        57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, &
        36, 38, 39, 41, 43, 44, 45, 46, 47, 49, 50, 51, 52, 55, 56, 57, 58, &
        61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 18, 21, 22, 25, &
        32, 36, 38, 39, 41, 43, 44, 45, 46, 47, 49, 50, 52, 55, 56, 57, 58, &
        59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 10, 16, &
        18, 20, 21/

      DATA (lu_icol_v(i),i=1009,1051)/22, 25, 27, 31, 32, 34, 35, 36, 38, 39, &
        40, 41, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, &
        58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73/


      DATA lu_crow_v/1, 4, 7, 19, 41, 43, 45, 47, 49, 51, 54, 56, 58, 63, 68, &
        71, 75, 79, 86, 96, 102, 107, 112, 119, 123, 128, 134, 146, 166, 170, &
        174, 181, 191, 195, 208, 214, 223, 228, 236, 244, 262, 273, 298, 307, &
        315, 323, 333, 343, 386, 395, 406, 420, 430, 460, 473, 486, 513, 526, &
        537, 555, 572, 598, 611, 635, 661, 699, 741, 804, 829, 890, 938, 968, &
        1004, 1052/


      DATA lu_diag_v/1, 4, 7, 19, 41, 43, 45, 47, 49, 51, 54, 56, 58, 63, 68, &
        71, 75, 79, 86, 96, 103, 108, 113, 119, 123, 128, 134, 148, 166, 170, &
        174, 185, 191, 196, 208, 215, 223, 228, 236, 246, 264, 278, 299, 308, &
        316, 324, 334, 363, 387, 397, 411, 421, 442, 463, 476, 500, 517, 528, &
        545, 563, 585, 602, 627, 651, 690, 733, 797, 823, 885, 934, 965, 1002, &
        1051, 1052/

!MODULE_DATA_RACM                                             
    END MODULE module_data_racm
