MODULE module_init_utilities

CONTAINS

 real function interp_0( v_in,  &
                         z_in, z_out, nz_in  )
 implicit none
 integer nz_in, nz_out
 real    v_in(nz_in), z_in(nz_in)
 real    z_out

 integer kp, k, im, ip
 logical interp, increasing_z 
 real    height, w1, w2
 logical debug
 parameter ( debug = .false. )

! does vertical coordinate increase or decrease with increasing k?
! set offset appropriately

 height = z_out

 if(debug) write(6,*) ' height in interp_0 ',height

 if (z_in(nz_in) .gt. z_in(1)) then

    if(debug) write(6,*) ' monotonic increase in z in interp_0 '
    IF (height > z_in(nz_in)) then
      if(debug) write(6,*) ' point 1 in interp_0 '
      w2 = (z_in(nz_in)-height)/(z_in(nz_in)-z_in(nz_in-1))
      w1 = 1.-w2
      interp_0 = w1*v_in(nz_in) + w2*v_in(nz_in-1)
    ELSE IF (height < z_in(1)) then
      if(debug) write(6,*) ' point 2 in interp_0 '
      w2 = (z_in(2)-height)/(z_in(2)-z_in(1))
      w1 = 1.-w2
      interp_0 = w1*v_in(2) + w2*v_in(1)
    ELSE
      if(debug) write(6,*) ' point 3 in interp_0 '
      interp = .false.
      kp = nz_in
      DO WHILE ( (interp .eqv. .false.) .and. (kp .ge. 2) )
        IF(   ((z_in(kp)   .ge. height) .and.     &
               (z_in(kp-1) .le. height))        )   THEN
          w2 = (height-z_in(kp))/(z_in(kp-1)-z_in(kp))
          w1 = 1.-w2
          interp_0 = w1*v_in(kp) + w2*v_in(kp-1)
          if(debug) write(6,*) ' interp data, kp, w1, w2 ',kp, w1, w2
          if(debug) write(6,*) ' interp data, v_in(kp), v_in(kp-1), interp_0 ', &
                     v_in(kp), v_in(kp-1), interp_0
          interp = .true.
        END IF
        kp = kp-1
      ENDDO
    ENDIF

 else

    if(debug) write(6,*) ' monotonic decrease in z in interp_0 '

    IF (height < z_in(nz_in)) then
      if(debug) write(6,*) ' point 1 in interp_0 '
      w2 = (z_in(nz_in)-height)/(z_in(nz_in)-z_in(nz_in-1))
      w1 = 1.-w2
      interp_0 = w1*v_in(nz_in) + w2*v_in(nz_in-1)
    ELSE IF (height > z_in(1)) then
      if(debug) write(6,*) ' point 2 in interp_0 '
      w2 = (z_in(2)-height)/(z_in(2)-z_in(1))
      w1 = 1.-w2
      interp_0 = w1*v_in(2) + w2*v_in(1)
    ELSE
      if(debug) write(6,*) ' point 3 in interp_0 '
      interp = .false.
      kp = nz_in
      height = z_out
      DO WHILE ( (interp .eqv. .false.) .and. (kp .ge. 2) )
        IF(   ((z_in(kp)   .le. height) .and.     &
               (z_in(kp-1) .ge. height))             )   THEN
          w2 = (height-z_in(kp))/(z_in(kp-1)-z_in(kp))
          w1 = 1.-w2
          interp_0 = w1*v_in(kp) + w2*v_in(kp-1)
          interp = .true.
        END IF
        kp = kp-1
      ENDDO
    ENDIF

 end if

 return
 END FUNCTION interp_0

!----------------------------------------------------------------
   REAL FUNCTION rsat(temperature,pressure)
!----------------------------------------------------------------
!
! Using formulas from various sources (Y. Yung, MM5/WRF model, etc.)
! that are valid for saturation pressures over ice at low temperatures
! and over ice and liquid at higher pressures
!
!----------------------------------------------------------------
   IMPLICIT NONE
!----------------------------------------------------------------

!  Input/Ouptut variables
   REAL, INTENT(IN   ) ::  temperature, pressure

!  Parameter variables

    REAL, PARAMETER :: MW_AIR = 43.49
    REAL, PARAMETER :: MW_WAT = 18.0152
    REAL, PARAMETER :: AA0    = 6.107799961
    REAL, PARAMETER :: AA1    = 4.436518521e-01
    REAL, PARAMETER :: AA2    = 1.428945805e-02
    REAL, PARAMETER :: AA3    = 2.650648471e-04
    REAL, PARAMETER :: AA4    = 3.031240396e-06
    REAL, PARAMETER :: AA5    = 2.034080948e-08
    REAL, PARAMETER :: AA6    = 6.136820929e-11
    REAL, PARAMETER :: C1     = 9.09718
    REAL, PARAMETER :: C2     = 3.56654
    REAL, PARAMETER :: C3     = 0.876793
    REAL, PARAMETER :: EIS    = 6.1071

!  Local variables

    REAL :: t1, esat, rhs

    IF ( temperature > 273.16 ) THEN
       t1 = temperature - 273.16
       esat =  AA0 + T1 * (AA1 + T1 * (AA2 + T1 * (AA3 + T1 * &
            (AA4 + T1 * (AA5 + T1 *  AA6)))))
    ELSE
       rhs =  -C1 * (273.16 / temperature - 1.)  &
             - C2 * LOG10(273.16 / temperature)  &
             + C3 * (1. - temperature / 273.16) + LOG10(EIS)
       esat = 10.**rhs
    END IF
    !  esat is in mbar -- need to convert to Pa
    esat = 100.*MAX(esat,0.)
    ! With the following definition of rsat, we have decided that
    ! Q (Qvapor, Qice, etc.) refers to mass mixing ratio per
    ! mass of the _TOTAL_ atmosphere, not to the dry atmosphere.  The
    ! only place this difference in definition should matter is here,
    ! with the saturation values, in the surface pressure fluxes (we
    ! account for CO2 but not for pressure changes due to H2O vapor
    ! pressure) and in adding the water vapor amounts to the total
    ! atmospheric pressure.  We will get to that when we need to.
    rsat = MW_WAT *esat / (MW_AIR * pressure)          

  END FUNCTION rsat

END MODULE module_init_utilities


