;----------------------------------------------------------------------
; get lat / lon / lev / wnd from input data
; input filenames are hardcorded - may need to change this later
; return an array (4,*), where the second dim is the number of 
;    input data to be plotted. 
;    The first dim contain the fields lat-lon-lev-wnd
;----------------------------------------------------------------------
undef("GetTrackData")
function GetTrackData(tkres)
begin

    if ( tkres@DataSource .eq. "RIP4" ) then
      filename = "TrackInput"

      ; Read lat/lon speed and pressure
      lat = stringtofloat(systemfunc("cut -c4-10 " + filename))
      lon = stringtofloat(systemfunc("cut -c13-20 " + filename))
      lev = stringtofloat(systemfunc("cut -c53-60 " + filename))
      wnd = stringtofloat(systemfunc("cut -c65-71 " + filename))

    end if

    if ( tkres@DataSource .eq. "AFWA" ) then
      filename = tkres@filename

      ; Read lat/lon speed and pressure
      lat = stringtofloat(systemfunc("cut -c29-34 " + filename))
      lon = stringtofloat(systemfunc("cut -c35-43 " + filename))
      lev = stringtofloat(systemfunc("cut -c44-50 " + filename))
      wnd = stringtofloat(systemfunc("cut -c51-57 " + filename))
  
    end if

    npoints = dimsizes(lat)
    ll_lev_wnd = new( (/4,npoints/) , float )
    ll_lev_wnd(0,:) = lat
    ll_lev_wnd(1,:) = lon
    ll_lev_wnd(2,:) = lev
    ll_lev_wnd(3,:) = wnd
    return (ll_lev_wnd)

end


;----------------------------------------------------------------------
; get date and time information for lables on plot
; input filenames are hardcorded - may need to change this later
;----------------------------------------------------------------------
undef("Get_dd_hh")
function Get_dd_hh(tkres)
begin

  if ( tkres@DataSource .eq. "RIP4" ) then
    filetime = "TimeInfo"

    ; Read Time stamps from separate file
    tm  = (systemfunc("cut -f1 " + filetime))

  end if

  if ( tkres@DataSource .eq. "AFWA" ) then

    ; Read Time stamps
    dd = (systemfunc("cut -c15-16 " + tkres@filename))
    hh = (systemfunc("cut -c18-19 " + tkres@filename))
    tm = dd + "/" + hh
  
  end if

  return (tm)

end


;----------------------------------------------------------------------
; get interval of the input data            
; input filenames are hardcorded - may need to change this later
;----------------------------------------------------------------------
undef("GetInterval")
function GetInterval(tkres)
begin
  if ( tkres@DataSource .eq. "RIP4" ) then
      interval = tkres@SetInterval
  end if
  if ( tkres@DataSource .eq. "AFWA" ) then
    ; This dataset has a full date, so we can calculate the interval of 
    ;      incoming data
      filename = tkres@filename
      mins = stringtofloat(systemfunc("cut -c21-22 " + filename))
    ; As the first time may be wrong, we use the 2nd and 3rd times for calculations
      interval = mins(3) - mins(2)
    ; We need to know the answer as a fraction of an hour
      interval = interval / 60.
  end if
  print("Data is coming it every " + interval + " hours" )
  return(interval)
end


;----------------------------------------------------------------------
; get start and end times to place on the map as information
; input filenames are hardcorded - may need to change this later
; return an array (2), where the the first string is the start 
;    time and the second one the end time
;----------------------------------------------------------------------
undef("GetTimeInfo")
function GetTimeInfo(tkres)
begin
  if ( tkres@DataSource .eq. "RIP4" ) then
    filehead = "TrackInfo"
    tstart = (systemfunc("cut -d' ' -f1 " + filehead))
    tend = (systemfunc("cut -d' ' -f2 " + filehead))
  end if
  if ( tkres@DataSource .eq. "AFWA" ) then
    tstart= systemfunc("head -n 1 " + tkres@filename  + " | cut -c7-19 ")
    tend  = systemfunc("tail -n 1 " + tkres@filename  + " | cut -c7-19 ")
  end if
  time_start_end = new(2,string)
  time_start_end(0) = tstart
  time_start_end(1) = tend
  return(time_start_end)
end


;----------------------------------------------------------------------
; get DataType and Hurricane Categories
; return an array (6), where the first dimension is the DataType
;    and the other 5 is cat1 to cat5
;----------------------------------------------------------------------
undef("GetCatInfo")
function GetCatInfo(tkres)
begin
  if ( tkres@DataSource .eq. "RIP4" ) then
    ; we know this data is in m/s
    DataType = "m/s"
    cat1 = 33.0
    cat2 = 42.0
    cat3 = 51.0
    cat4 = 59.0
    cat5 = 69.0
  end if
  if ( tkres@DataSource .eq. "AFWA" ) then
    ; we know this data is in kts
    DataType = "kts"
    cat1 = 64.0
    cat2 = 84.0
    cat3 = 97.0
    cat4 = 114.0
    cat5 = 135.0
  end if
  cat = new(6,string)
  cat(0) = DataType
  cat(1) = cat1
  cat(2) = cat2
  cat(3) = cat3
  cat(4) = cat4
  cat(5) = cat5
  return(cat)
end


;----------------------------------------------------------------------
; Plot best track if asked for
; currently only a standard plot, but this can be changed
;----------------------------------------------------------------------
undef("PlotBestTrack")
procedure PlotBestTrack(wks,map,tkres)
begin

    lat  = stringtofloat(systemfunc("cut -c18-21 " + tkres@btFile))
    lon  = stringtofloat(systemfunc("cut -c24-27 " + tkres@btFile))
    lon = -lon
    bthh  = systemfunc("cut -c1-2 " + tkres@btFile)
    btdd  = systemfunc("cut -c11-12 " + tkres@btFile)
    btdate = btdd + "/" + bthh
    btcat = stringtoint(systemfunc("cut -c33-35 " + tkres@btFile))

    lnres = True
    ;lnres@gsLineThicknessF = 1.8
    lnres@gsLineThicknessF = 2.6
    ;lnres@gsLineDashPattern = 6
    do i=0,dimsizes(lat)-2
         lnres@gsLineColor    = "Red"
      if ( lon(i) .lt. -75 ) then
         gsn_polyline(wks,map,(/lon(i),lon(i+1)/),(/lat(i),lat(i+1)/),lnres)
      end if
    end do

    txres2               = True
    txres2@txFont        = "helvetica-bold"
    txres2@txFontHeightF = 0.008
    txres2@txJust        = "CenterLeft"
    txres2@txAngleF        = 45.00
    lnres2                  = True
    lnres2@gsLineColor      = "Black"
    lnres2@gsLineThicknessF = 0.7
    pmres = True
    pmres@gsMarkerIndex = create_hurricane_symbol(wks)
    do i=0,dimsizes(lat)-1
      pmres@gsMarkerColor = "Black"
      pmres@gsMarkerIndex = 16
      pmres@gsMarkerSizeF = 0.005
      if (btcat(i) .ge. 74) then
        pmres@gsMarkerColor = 5
      end if
      if (btcat(i) .ge. 96) then
        pmres@gsMarkerColor = 6
      end if
      if (btcat(i) .ge. 111) then
        pmres@gsMarkerColor = 7
      end if
      if (btcat(i) .ge. 131) then
        pmres@gsMarkerColor = 8
      end if
      if (btcat(i) .ge. 155) then
        pmres@gsMarkerColor = 9 
      end if

      if (btcat(i) .ge. 74) then
        pmres@gsMarkerIndex = create_hurricane_symbol(wks)
        pmres@gsMarkerSizeF = 0.01
      end if

      gsn_polyline(wks,map,(/lon(i),lon(i)+1.0/),(/lat(i),lat(i)+1.0/),lnres2)
      gsn_polymarker(wks,map,lon(i)+1.0,lat(i)+1.0,pmres)
      if ( bthh(i) .eq. "03" )then
        gsn_text(wks,map,btdate(i),lon(i)+1.2,lat(i)+1.2,txres2)
      end if

    end do  

end
