MODULE module_rotate_utilities

  USE module_model_constants

CONTAINS

  SUBROUTINE rotate_coords(ilat,ilon,olat,olon,lat_np,lon_np,lon_0,direction,&
                           sinchi,coschi)
    IMPLICIT NONE
    REAL, INTENT(IN   ) :: ilat, ilon
    REAL, INTENT(  OUT) :: olat, olon
    REAL, INTENT(IN   ) :: lat_np, lon_np, lon_0
    INTEGER, INTENT(IN  ), OPTIONAL :: direction
    ! >=0, default : computational -> geographical
    ! < 0          : geographical  -> computational
    REAL, INTENT(  OUT), OPTIONAL   :: sinchi, coschi

    REAL :: raddeg                      ! 180./pi, rad->deg conversion
    REAL :: rlat, rlon
    REAL :: pi, phi_np, lam_np, lam_0, dlam
    REAL :: sinphi, cosphi, coslam, sinlam

    raddeg = 1./degrad
    pi = ACOS(-1.)

    ! Convert all angles to radians
    phi_np = lat_np * degrad
    lam_np = lon_np * degrad
    lam_0  = lon_0  * degrad
    rlat = ilat * degrad
    rlon = ilon * degrad

    IF (PRESENT(direction) .AND. (direction < 0)) THEN
       ! The equations are exactly the same except for one small difference
       ! with respect to longitude ...
       dlam = pi - lam_0
    ELSE
       dlam = lam_np
    END IF
    sinphi = COS(phi_np)*COS(rlat)*COS(rlon-dlam) + SIN(phi_np)*SIN(rlat)
    !cosphi = COS(ASIN(sinphi))
    cosphi = SQRT(1.-sinphi*sinphi)
    coslam = SIN(phi_np)*COS(rlat)*COS(rlon-dlam) - COS(phi_np)*SIN(rlat)
    sinlam = COS(rlat)*SIN(rlon-dlam)
    IF ( cosphi /= 0. ) THEN
       coslam = coslam/cosphi
       sinlam = sinlam/cosphi
    END IF
    olat = raddeg*ASIN(sinphi)
    olon = raddeg*(ATAN2(sinlam,coslam)-dlam-lam_0+lam_np)
    ! Both of my F90 text books prefer the DO-EXIT form, and claim it is faster
    ! when optimization is turned on (as we will always do...)
    DO
       IF (olon >= -180.) EXIT
       olon = olon + 360.
    END DO
    DO
       IF (olon <=  180.) EXIT
       olon = olon - 360.
    END DO
    IF (PRESENT(direction) .AND. (direction < 0)) THEN
       sinchi = COS(phi_np)*SIN(olon*degrad-lam_np)/COS(rlon)
       coschi = (cosphi*SIN(phi_np) - &
                 COS(olon*degrad-lam_np)*COS(phi_np)*sinphi)/COS(rlon)
    ELSE
       sinchi = COS(phi_np)*SIN(rlon-lam_np)/cosphi
       coschi = (COS(rlat)*SIN(phi_np) - &
                 COS(rlon-lam_np)*COS(phi_np)*SIN(rlat))/cosphi
    END IF

  END SUBROUTINE rotate_coords

END MODULE module_rotate_utilities
