!WRF:MODEL_LAYER:CONSTANTS
!

 MODULE module_model_constants

   !  2. Following are constants for use in defining real number bounds.

   !  A really small number.

   REAL    , PARAMETER :: epsilon         = 1.E-15

   !  4. Following is information related to the physical constants.

   !  These are the physical constants used within the model.

! JM NOTE -- can we name this grav instead?
   real, save :: g, & !gravity
        &r_d, & ! gas constant / mol. mass
        &cp, &     ! specific heat constant pressure
        &mass_atm   ! mass of the atmosphere

   real, save :: &
        & r_v, cv, cpv, cvv, &
        & cvpm, cliq, cice, psat, rcv, rcp,&
        & rovg, c2

   real, save :: p0, p1000mb, t0, mwdry

   real, save :: cpovcv, cvovcp, rvovrd

   real, save :: reradius ! 1./m

   REAL    , PARAMETER :: asselin      = .025
!   REAL    , PARAMETER :: asselin      = .0
   REAL    , PARAMETER :: cb           = 25.

   REAL    , PARAMETER :: XLV0         = 3.15E6
   REAL    , PARAMETER :: XLV1         = 2370.
   REAL    , PARAMETER :: XLS0         = 2.905E6
   REAL    , PARAMETER :: XLS1         = 259.532

   REAL    , PARAMETER :: XLS          = 2.85E6
   REAL    , PARAMETER :: XLV          = 2.5E6
   REAL    , PARAMETER :: XLF          = 3.50E5

   REAL    , PARAMETER :: rhowater     = 1000.
   REAL    , PARAMETER :: rhosnow      = 100.
   
   real, save:: rhoair0

   REAL    , PARAMETER :: DEGRAD       = 3.1415926/180.
   real, save ::dpd

   REAL    , PARAMETER ::  SVP1=0.6112
   REAL    , PARAMETER ::  SVP2=17.67
   REAL    , PARAMETER ::  SVP3=29.65
   REAL    , PARAMETER ::  SVPT0=273.15
   real, save :: ep_1, ep_2

   REAL    , PARAMETER ::  KARMAN=0.4

   real, save :: eomeg

   REAL    , PARAMETER ::  STBOLT=5.67051E-8

                                      ! proportionality constants for eddy viscosity coefficient calc
   REAL    , PARAMETER ::  c_s = .25  ! turbulence parameterization constant, for smagorinsky
   REAL    , PARAMETER ::  c_k = .15  ! turbulence parameterization constant, for TKE
   REAL    , save ::  prandtl
                                         ! constants for w-damping option
   REAL    , PARAMETER ::  w_alpha = 0.3 ! strength m/s/s
   REAL    , PARAMETER ::  w_beta  = 1.0 ! activation cfl number

       REAL , PARAMETER ::  pq0=379.90516
!      REAL , PARAMETER ::  epsq2=0.2
       REAL , PARAMETER ::  epsq2=0.02
       REAL , PARAMETER ::  a2=17.2693882
       REAL , PARAMETER ::  a3=273.16
       REAL , PARAMETER ::  a4=35.86
       REAL , PARAMETER ::  epsq=1.e-12
       real, save :: p608
!#if ( NMM_CORE == 1 )
       REAL , PARAMETER ::  climit=1.e-20
       REAL , PARAMETER ::  cm1=2937.4
       REAL , PARAMETER ::  cm2=4.9283
       REAL , PARAMETER ::  cm3=23.5518
!       REAL , PARAMETER ::  defc=8.0
!       REAL , PARAMETER ::  defm=32.0
       REAL , PARAMETER ::  defc=0.0
       REAL , PARAMETER ::  defm=99999.0
       REAL , PARAMETER ::  epsfc=1./1.05
       REAL , PARAMETER ::  epswet=0.0
       REAL , PARAMETER ::  fcdif=1./3.
!       REAL , PARAMETER ::  fcm=0.003
       REAL , PARAMETER ::  fcm=0.0

       real, save :: gma
       REAL , PARAMETER ::  p400=40000.0
       REAL , PARAMETER ::  phitp=15000.0
       REAL , PARAMETER ::  pi2=2.*3.1415926
       REAL , PARAMETER ::  plbtm=105000.0
       REAL , PARAMETER ::  plomd=64200.0
       REAL , PARAMETER ::  pmdhi=35000.0
       REAL , PARAMETER ::  q2ini=0.50
       REAL , save ::  rfcp
       REAL , PARAMETER ::  rhcrit_land=0.75
       REAL , PARAMETER ::  rhcrit_sea=0.80
       REAL , PARAMETER ::  rlag=14.8125
       REAL , PARAMETER ::  rlx=0.90
       REAL , PARAMETER ::  scq2=50.0
       REAL , PARAMETER ::  slopht=0.001
       REAL , PARAMETER ::  tlc=2.*0.703972477
       REAL , PARAMETER ::  wa=0.15
       REAL , PARAMETER ::  wght=0.35
       REAL , PARAMETER ::  wpc=0.075
       REAL , PARAMETER ::  z0land=0.10
       REAL , PARAMETER ::  z0max=0.01
       REAL , PARAMETER ::  z0sea=0.001
!#endif

   !  Dummy constants
   !  Need to set these to make sure code compiles

   ! This is universal, true for any planet
   REAL    , PARAMETER :: co2_lheat    = 5.9e5 ! J/kg

   integer , save :: planet_year
   real, save :: semimajoraxis, zero_date, equinox_fraction
   REAL , save :: OBLIQUITY, eccentricity

   real, save :: rhogrnd

   real :: temp
   character(len=128) :: debug_line
   real, private,parameter :: not_defined=-9999.0
   real, save :: co2snow_threshold, h2oice_threshold

 CONTAINS
   SUBROUTINE init_module_model_constants
     use module_configure, only: model_config_rec
     use module_wrf_error
     implicit none

      call wrf_debug(100, "begin init module_model_constants")
!     write(*,*) model_config_rec%planet_namelist_setup, model_config_rec%rotation_rate, model_config_rec%khdif, model_config_rec%ra_lw_physics


           !  EOMEG USES THE SIDEREAL DAY (NOT SOLAR DAY)
           !  EOMEG = 2*PI/SIDEREAL DAY IN SECONDS
      CO2SNOW_THRESHOLD=1.e99
      H2OICE_THRESHOLD=1.e99

#if defined MARS
      CO2SNOW_THRESHOLD=100.
      H2OICE_THRESHOLD=10.

           !  Mars
           !  Sidereal day is 88642.663s for Mars
          mwdry = 44.0
           mass_atm = 2.647e16 ! mass of the atmosphere for a flat planet
           EOMEG=7.08822E-5
           obliquity  = 25.19
           eccentricity  = 0.093
           p1000mb = 680.23
           t0=300.
           g=3.711
           r_d = 8.3142e3/43.49 ! J/K/Kg
           cp = 4*r_d ! 8/2 linear triatomic molecule
           reradius     = 1./3389.92e03 ! 1/m
           rhoair0      = 0.0117      ! Looks like P0/R/273 K!
           DPD          = 360./669.
           PLANET_YEAR = 669
           SEMIMAJORAXIS = 1.52366 ! In AU
           zero_date = 489.2045      ! Time of perihelion passage (sols)
           EQUINOX_FRACTION= 0.2695
           rhogrnd = 1.5e3 ! kg/m^3, density of soil 
#elif defined TITAN
           !  Titan
           !  Sidereal day is 1378080?????s for Titan
           mwdry = 28.0
           mass_atm = 9.20e18 ! mass of the atmosphere for a flat planet
           EOMEG=4.55937638e-6
           obliquity  = 26.7
           eccentricity  = 0.056
           p1000mb = 150000.
           t0=120.
           g=1.358
           r_d = 290.
           cp = 1044.0
           reradius     = 1./2575.e03
           rhoair0      = 1.28 ! CEN - TEMPORARY
           DPD          = 360./686.
           PLANET_YEAR = 686
           SEMIMAJORAXIS = 9.58256
           zero_date = 542.56   ! Time of perihelion passage
           EQUINOX_FRACTION= ((PLANET_YEAR)-zero_date)/PLANET_YEAR
           rhogrnd      = 800.0 ! kg/m^3, density of soil
#elif defined VENUS
           !  Venus (CL 2006-06-04)
           !  Sidereal day is 5832.5 * 3600 = 20,997,000 s for venus
           !  http://nssdc.gsfc.nasa.gov/planetary/factsheet/venusfact.html
           mwdry = 44.0
           mass_atm = 4.77E20
           EOMEG=2.99242049e-7
           obliquity  = 2.64
           eccentricity  = 0.0067
           p1000mb=92.e5
           t0=737.
           g=8.87 !L. Colin, VENUS II, P 17.
           r_d = 188.92
           cp = 840.10
           reradius     = 1./6051.3e03
           rhoair0      = 178.380 ! CL - 92bar/(188.91J/kg/K*273K) 
           DPD          = 360./1.925
           PLANET_YEAR = 2
           SEMIMAJORAXIS = 0.723 !3sf
           zero_date = 0.70025   ! Time of perihelion passage
           EQUINOX_FRACTION= ((PLANET_YEAR)-zero_date)/PLANET_YEAR
   !  Surface property constants
   rhogrnd      = 2800.0 ! kg/m^3, density of soil
   ! VENUS II G. E. McGill et al. for Venera 10 landing site (2.8 +- 0.1 g /cm^3)
   ! http://nssdc.gsfc.nasa.gov/planetary/factsheet/venusfact.html (180-177.36) = 2.64
#else
           !Earth 
           mwdry = 28.966
           mass_atm = 5.20e18
           EOMEG=7.2921E-5
           obliquity  = 23.5
           eccentricity  = 0.014
           p1000mb=100000.
           t0=300.
           g=9.81
           r_d = 287.0
           cp = 7.*r_d / 2.
           reradius     = 1./6370.e03 
           rhoair0      = 1.28
           DPD          = 360./365.
           PLANET_YEAR = 365
           SEMIMAJORAXIS = 1.0 ! In AU
           zero_date = 0.0   ! Time of perihelion passage
           EQUINOX_FRACTION= 0.0
           rhogrnd           = 2.e3
#endif

#if (NMM_CORE == 1)
           r_d = 287.04
           cp = 1004.06
#endif

!common values
   prandtl = 1./3.0

!common values
     p0           = p1000mb
     r_v          = 461.6  ! J/K/kg, water
     cv           = cp-r_d
     cpv          = 4.*r_v
     cvv          = cpv-r_v
     cvpm         = -cv/cp
     cliq         = 4190.
     cice         = 2106.
     psat         = 610.78
     rcv          = r_d/cv
     rcp          = r_d/cp
     rovg         = r_d/g
     c2           = cp * rcv


     cpovcv       = cp/(cp-r_d)
     cvovcp       = 1./cpovcv
     rvovrd       = r_v/r_d


     EP_1=R_v/R_d-1.
     EP_2=R_d/R_v
     p608 = rvovrd - 1.
     gma=-r_d*(1.-rcp)*0.5
     rfcp=0.25/cp

     
101  format(a,e10.4,a)
102  format(a,e10.4)
     
     write(debug_line, 101) "Rotation rate = ", eomeg , " s-1"
     call wrf_debug(100, debug_line)

     write(debug_line, 101) "Obliquity = ", obliquity , " degrees"
     call wrf_debug(100, debug_line)

     write(debug_line, 102) "Eccentricity = ", eccentricity
     call wrf_debug(100, debug_line)

     write(debug_line, 101) "p0 = ", p0, " Pa"
     call wrf_debug(100, debug_line)

     write(debug_line, 101) "t0 = ", t0, " K"
     call wrf_debug(100, debug_line)

     write(debug_line, 101) "R_d = ", r_d, " J/K/Kg"
     call wrf_debug(100, debug_line)

     write(debug_line, 101) "CP = ", cp, " J/K/Kg"
     call wrf_debug(100, debug_line)

     write(debug_line, 101) "Gravity = ", g, " m/s"
     call wrf_debug(100, debug_line)

     write(debug_line, 102) "Prandtl = ", prandtl
     call wrf_debug(100, debug_line)

      call wrf_debug(100, "end init module_model_constants")


   END SUBROUTINE init_module_model_constants
 END MODULE module_model_constants
