#!/bin/csh

#BSUB -a poe                            # at NCAR: bluevista
#BSUB -P 25000032			# proj account to charge	
#BSUB -R "span[ptile=8]"                # how many tasks per node (up to 8)
#BSUB -n 128                            # number of total tasks
#BSUB -o run.out                        # output filename (%J to add job id)
#BSUB -e run.err                        # error filename
#BSUB -J run.test                       # job name
#BSUB -q premium                        # queue
#BSUB -W 6:00                           # wallclock time

cd /ptmp/gill/global/WRFV2_top_parallel/test/em_real

set EW    = ( 641 257 )
set SN    = ( 321 129 )

set START = ( 2006-07-19_12:00:00 2007-01-15_12:00:00 )
set START = ( 2007-01-15_12:00:00 )

set case_count = 1

while ( $case_count <= ${#START} )
		
	set syy = `echo ${START[$case_count]} | cut -c 1-4`
	set smm = `echo ${START[$case_count]} | cut -c 6-7`
	set sdd = `echo ${START[$case_count]} | cut -c 9-10`
	set shh = `echo ${START[$case_count]} | cut -c 12-13`

	set res_count = 1

	while ( $res_count <= ${#EW} )

 		foreach CU ( 1 3 )

			foreach RAD ( 1 2 3 )

				if ( ( ${EW[$res_count]} == 641 ) && ( $RAD != 2 ) )  then
					echo skipping ${syy}${smm}${sdd}${shh} wrfinput for CU = $CU RAD = $RAD ${EW[$res_count]}x${SN[$res_count]}
					goto LOOP_END
				endif

				if      ( $RAD == 1 ) then
					set RADLW = 1
					set RADSW = 1
				else if ( $RAD == 2 ) then
					set RADLW = 1
					set RADSW = 2
				else if ( $RAD == 3 ) then
					set RADLW = 3
					set RADSW = 3
				endif

				rm -rf wrfi* >& /dev/null
				ln -sf ${syy}${smm}${sdd}${shh}.cu=${CU}.rad=${RAD}.${EW[$res_count]}x${SN[$res_count]}/wrfi* .

				if      ( ${EW[$res_count]} == 257 ) then
					set DX = `ncdump -h met_em.* | grep DX | cut -d= -f2 | cut -df -f1`
					set DT = 600
				else if ( ${EW[$res_count]} == 641 ) then
					set DX = `ncdump -h met_em.* | grep DX | cut -d= -f2 | cut -df -f1`
					set DT = 240
				endif

				m4 -DSYY=$syy \
				   -DSMM=$smm \
				   -DSDD=$sdd \
				   -DSHH=$shh \
				   -DDT=$DT \
				   -DDX=${DX} \
				   -DXXEWXX=${EW[$res_count]} \
				   -DXXSNXX=${SN[$res_count]} \
				   -DXXCUXX=$CU \
				   -DXXRADLWXX=$RADLW \
				   -DXXRADSWXX=$RADSW \
				   namelist.input.template >! namelist.input
		
				echo processing ${syy}${smm}${sdd}${shh} wrfinput for CU = $CU RAD = $RAD ${EW[$res_count]}x${SN[$res_count]}

				rm rsl*
				mpirun.lsf wrf.exe
		
				mv wrfo* rsl* ${syy}${smm}${sdd}${shh}.cu=${CU}.rad=${RAD}.${EW[$res_count]}x${SN[$res_count]}
LOOP_END:
			end

		end

		@ res_count ++

	end

	@ case_count ++
end
