#!/bin/csh

#BSUB -a poe                            # at NCAR: bluevista
#BSUB -P 25000032			# proj account to charge	
#BSUB -R "span[ptile=8]"                # how many tasks per node (up to 8)
#BSUB -n 32                             # number of total tasks
#BSUB -o run32.out                      # output filename (%J to add job id)
#BSUB -e run32.err                      # error filename
#BSUB -J run32.test                     # job name
#BSUB -q premium                        # queue
#BSUB -W 0:40                           # wallclock time

cd /ptmp/gill/global/WRFV2_top_parallel/test/em_real
rm rsl*

#foreach case ( 256x128 512x256 1024x512 810x405 )
foreach case ( 810x405 )
	if ( -e wrfinput_d01 ) rm wrfinput_d01
	ln -s /ptmp/gill/global/wrfinput_d01.$case wrfinput_d01
	cp /ptmp/gill/global/namelist.input.$case namelist.input

	echo DAVE start `date` CASE = $case
	mpirun.lsf wrf.exe
	echo DAVE end `date` CASE = $case

	if ( -d $case ) rm -rf $case
	mkdir $case
	mv wrfo* rsl* wrfinput_d01 $case
	cp namelist.input $case
end
