"direct.read" <- 
function(file, reclen, rec1 = 1, recN = 1, unit = 86, type = "real")
{
	#-----------------------------------------------------------------------
	#
	# This reads Fortran direct-access binary records
	# into a (multidimensional) array. 
	#
	# USAGE:
	#
	# directread(filename, reclen, rec1, recN, unit, type)
	#
	#     filename		chacter string
	#     reclen		number of elements in a record
	#     rec1		first record to return
	#     recN		last  record to return
	#     unit		The Fortran unit for reading [default is 95]
	#     type		Data type -- INTEGER, REAL, REAL*8
	#
	# Since there is no way to determine if you are lying or mistaken, 
	# it is your responsibility to know if you are doing "the right thing"
	# 
	# Reading (or writing, for that matter) a file with mixed record
	# lengths is tough, if not impossible, with this file format) 
	#
	#-----------------------------------------------------------------------
	if((rec1 > 1) & (recN == 1)) {
		recN <- rec1
	}
	cherr <- "                                        "
	xlen <- reclen * (recN - rec1 + 1)
	type <- tolower(type)
	if(type == tolower("real*8")) {
		datalist <- .Fortran("ddirectread",
			file = as.character(file),
			unit = as.integer(unit),
			reclen = as.integer(reclen),
			rec1 = as.integer(rec1),
			recN = as.integer(recN),
			y = double(reclen),
			x = double(xlen),
			ierr = integer(length = 1),
			cherr = as.character(paste(cherr, cherr)))
	} else if(type == tolower("integer")) {
		datalist <- .Fortran("idirectread",
			file = as.character(file),
			unit = as.integer(unit),
			reclen = as.integer(reclen),
			rec1 = as.integer(rec1),
			recN = as.integer(recN),
			y = integer(reclen),
			x = integer(xlen),
			ierr = integer(length = 1),
			cherr = as.character(paste(cherr, cherr)))
	}
	else {
		datalist <- .Fortran("directread",
			file = as.character(file),
			unit = as.integer(unit),
			reclen = as.integer(reclen),
			rec1 = as.integer(rec1),
			recN = as.integer(recN),
			y = single(reclen),
			x = single(xlen),
			ierr = integer(length = 1),
			cherr = as.character(paste(cherr, cherr)))
	}
	if(datalist$ierr == -1) {
		print(paste("ERROR:Unable to open input file", datalist$file))
		print(datalist$cherr)
	} else if(datalist$ierr == -2) {
		print(paste("ERROR:Unable to read input file", datalist$file))
		print(datalist$cherr)
	}
	else if(datalist$ierr == -3) {
		print(paste("ERROR:Early end of input file", datalist$file))
		print(datalist$cherr)
	}
	else {
		print(paste("Read", as.character(datalist$ierr), "items."))
		return(array(datalist$x, dim = c(reclen, recN - rec1 + 1)))
	}
}

