"getncvar" <- 
function(filename, varname = "NULL")
{
	#----------------------------------------------------------------------
	# This gets a NETCDF variable of unknown shape/size/type and returns
	# it as a "list".
	#
	#----------------------------------------------------------------------
	cherr <- "                                        "
	#----------------------------------------------------------------------
	# If there is a problem with finding the dimensions, etc. prepare
	# the returned list to return a blank.
	#----------------------------------------------------------------------
	if(varname == "NULL") {
		var <- unix(paste("ncdump -h ", filename), output = F)
	}
	else {
		var <- list(filename = filename, varname = varname, ndims = 0,
			dimlens = 0, tsize = 0, x = 0, ierr = 0, cherr = cherr)
		#----------------------------------------------------------------------
		# Get the total size of the variable so I can allocate an array in 
		# Splus to hold the darn thing. Can also return the number of 
		# dimensions and then make an array to hold the dimensions.
		#----------------------------------------------------------------------
		dims <- .Fortran("getnfdims",
			filename = as.character(filename),
			varname = as.character(varname),
			ndims = integer(length = 1),
			tsize = integer(length = 1),
			ierr = integer(length = 1),
			cherr = as.character(paste(cherr, cherr)))
		if(dims$ierr != 0) {
			print("ERROR")
			print(dims$cherr)
			var$ierr <- dims$ierr
			var$cherr <- dims$cherr
			return(NULL)
		} else {
			#----------------------------------------------------------------------
			# If we were able to read the dimensions, etc., get the variable.
			#----------------------------------------------------------------------
			var <- .Fortran("getnfvar",
				filename = as.character(filename),
				varname = as.character(varname),
				ndims = as.integer(dims$ndims),
				dimlens = integer(length = dims$ndims),
				tsize = as.integer(dims$tsize),
				x = double(length = dims$tsize),
				ierr = integer(length = 1),
				cherr = as.character(paste(cherr, cherr)))
			if(var$ierr != 0) {
				print("ERROR")
				print(var$cherr)
				return(NULL)
			}
		}
		newdata <- list(filename = var$filename, varname = var$varname,
			shape = var$dimlens, x = array(data = var$x, dim = var$
			dimlens), ierr = var$ierr, cherr = var$cherr)
		return(newdata)
	}
}
