\name{direct.write}
\alias{direct.write}
\author{Tim Hoar \email{thoar@ucar.edu} \url{http://www.cgd.ucar.edu/~thoar} }
\title{Fortran "direct-access" write}
\description{
  writes R objects into Fortran "direct-access" binary file.
}
\synopsis{
   direct.write(file=NULL, NDarray=NULL, unit=85, type="real")
}
\usage{
   direct.write(file, NDarray)
   direct.write(file, NDarray, type="integer")
}

\arguments{

   \item{file}{The file name.}

   \item{NDarray}{The N-dimensional R array.}

   \item{unit}{[optional] integer to describe the Fortran unit. This is only
   needed if you intend to write/write from multiple files simultaneously.
   Fortran associates a file with a unique (hopefully) integer and uses
   the integer for everything.  Stay away from unit == 5, unit == 6,
   which can have special meaning./cr
   unit == 85 [default]}

   \item{type}{[optional] character string to describe the Fortran variable
   type.\cr
   type == "real" [default]\cr
   type == "real*8"\cr
   type == "integer"}

}
\value{
   \item{An number of items written ... }
}

\details{
   \emph{IMPORTANT} If you have multiple files open (for reading or writing),
   \emph{you} had best keep track of which unit is which file. Doing otherwise is
   going to produce undesirable results, guaranteed.
}

\examples{
# Create some data and 
# write it out as 32 bit "reals" ...
#
   datmat <- array(c(111,121,112,122,113,123,
                     211,221,212,222,213,223,
                     311,321,312,322,313,323,
                     411,421,412,422,413,423),c(2,3,4))
   A <- direct.write("daR4.ieee", datmat)
#
# write the same thing as 64bit reals ...
#
A <- direct.write("daR8.ieee", datmat, type="real*8")
}

\note{
   Fortran direct access is primarily used for non-sequential access.
   Since there is no record information it is possible to get extremely lost.
   For this reason, I am not currently implementing the ability to "append" to
   a file. You get ONE chance to blast data into a file.
}

\seealso{ \code{\link{direct.read}, \link{flat.read}, \link{flat.write} } }

\keyword{IO}
