      subroutine dflatread(filename,nunit,nrow,ncol,irec1,irecN,datmat,
     &            ioflag,ierr,cherr)
C-----------------------------------------------------------------------
C
C     ioflag == 1	open, read and close the file
C     ioflag == 2	open, read, and leave the file open
C     ioflag == 3	read and leave the file open 
C     ioflag == 4	read and close the file 
C
C     The return value (error code) returned in "ierr" can be
C     decoded as follows:
C
C     ierr > 0		normal termination, # of items read
C     ierr == -1	unable to open input file
C     ierr == -2	unable to read input file
C     ierr == -3	premature end-of-file
C
C-----------------------------------------------------------------------

      implicit none

      character*256 filename
      integer	nunit,nrow,ncol
      integer	irec1			! the first record to output
      integer	irecN			! the last  record to output
      real*8    datmat(nrow,ncol,irecN-irec1+1)
      integer	ioflag
      integer	ierr
      character*80 cherr

      integer i,j,k,ikeep

C --- ------------------------------------------------------------------
C --- Do Something
C --- ------------------------------------------------------------------

      if (ioflag .LE. 2) then
         open(nunit,file=filename,status='old',form='unformatted',
     &     err=900)
         rewind(nunit)
      endif

      ikeep = 1
      do k = 1,irecN		! gotta read through to irecN

         read(nunit,err=901,end=902)
     &        ((datmat(i,j,ikeep),i=1,nrow),j=1,ncol)

         if (k .ge. irec1) then
            ikeep = ikeep + 1
         endif

      enddo

      if ( (ioflag .EQ. 1) .OR. (ioflag .EQ. 4) ) then
         close(nunit)
      endif

      ierr = nrow*ncol*(irecN-irec1+1)

      goto 999

 900  ierr = -1
      cherr = "ERROR(dflatread): unable to open input file "
      goto 999

 901  ierr = -2
      cherr = "ERROR(dflatread): unable to read matrix "
      goto 999

 902  ierr = -3
      cherr = "ERROR(dflatread): premature END-OF-FILE "
      goto 999

 999  continue

      return
      end
