      subroutine idirectread(filename,nunit,reclen,rec1,recN,y,datvec,
     &              ierr,cherr)
C-----------------------------------------------------------------------
C --- Direct access reads are easier than unformatted. Since they
C --- are "random access", you can open/close the file at will and
C --- not lose any generality. The record length is fixed, however,
C --- and there is no way to check if you are reading what you think
C --- you are reading.
C-----------------------------------------------------------------------

      implicit none

      character*256     filename                ! the filename, duh
      integer           nunit                   ! Fortran unit
      integer           reclen                  ! items in a record
      integer           rec1                    ! which record
      integer           recN                    ! which record
      integer           y(reclen)               ! temp vector
      integer           datvec(reclen,recN-rec1+1)        ! data vector
      integer           ierr                    ! error code
      character*80      cherr                   ! error string

C --- ------------------------------------------------------------------
C --- Do Something
C --- ------------------------------------------------------------------

      integer irec,reci,i

      reci = 0

      open(nunit,file=filename,status='old',access='direct',
     &                  recl=reclen*4,err=900)

      do irec = rec1,recN
         read(nunit,rec=irec,err=901)y

         reci = irec - rec1 + 1

         do i = 1,reclen
          datvec(i,reci) = y(i)
         enddo
      enddo 

      close(nunit,err=902)
      ierr = reci * reclen
      goto 999

 900  ierr = -1
      cherr = "ERROR(idirectread): unable to open input file "
      goto 999

 901  ierr = -2
      cherr = "ERROR(idirectread): unable to read record "
      goto 999

 902  ierr = -3
      cherr = "ERROR(idirectread): unable to close file. "
      goto 999

 999  continue
      return
      end
