      FUNCTION INPOLY (XPNT,YPNT,NP,XP,YP)
C
      PARAMETER (PI=3.14159265358979,TTPI=2.*PI)
C
      DIMENSION XP(NP),YP(NP)
C
C----------------------------------------------------------------------
C
C  The value of this function is non-zero if and only if (XPNT,YPNT) is
C  strictly inside the polygon defined by the points (XP(I),YP(I)), 
C  for I from 1 to NP.
C
C  The input polygon does not have to be a closed polygon, that is
C  it does not have to be that (XP(1),YP(1) = (XP(NP,YP(NP)).
C
C----------------------------------------------------------------------
C
C  Determine the number of points to look at (depending on whether the
C  caller made the last point a duplicate of the first or not).
C
      IF (XP(NP).EQ.XP(1) .AND. YP(NP).EQ.YP(1)) THEN
        NPTS = NP-1
      ELSE
        NPTS = NP
      END IF
C
C  Compute the total angular change described by a ray emanating from
C  the point (XPNT,YPNT) and passing through a point that moves around
C  the polygon.
C
      ANCH = 0.
C
      INXT = NPTS
      XNXT = XP(NPTS)
      YNXT = YP(NPTS)
      IF (XNXT.EQ.XPNT .AND. YNXT.EQ.YPNT) THEN
        INPOLY = 0
        RETURN
      ELSE
        ANXT = ATAN2(YNXT-YPNT, XNXT-XPNT)
      END IF
C
      DO 100 IPNT=1,NPTS
        ILST = INXT
        XLST = XNXT
        YLST = YNXT
        ALST = ANXT
        INXT = IPNT
        XNXT = XP(INXT)
        YNXT = YP(INXT)
        IF (XNXT.EQ.XPNT .AND. YNXT.EQ.YPNT) THEN
          INPOLY = 0
          RETURN
        ELSE
          ANXT = ATAN2(YNXT-YPNT, XNXT-XPNT)
        END IF
        ADIF = ANXT-ALST
        IF (ABS(ADIF) .GT. PI) ADIF = ADIF - SIGN(TTPI,ADIF)
        ANCH = ANCH + ADIF
  100 CONTINUE
C
C  If the point is outside the polygon, the total angular change should
C  be exactly zero, while if the point is inside the polygon, the total
C  angular change should be exactly plus or minus two pi.  We just test
C  for the absolute value of the change being less than or equal to pi.
C
      IF (ABS(ANCH) .LT. PI) THEN
        INPOLY = 0
      ELSE
        INPOLY = 1
      END IF
C
      RETURN
      END



      function inpoly2(xpnt,ypnt,np,xp,yp)
C
      parameter (pi=3.14159265358979,ttpi=2.*pi)
C
      dimension xp(np),yp(np)
C
C----------------------------------------------------------------------
C
C  THE VALUE OF THIS FUNCTION IS NON-ZERO IF AND ONLY IF (XPNT,YPNT) 
C  IS INSIDE OR *ON* THE POLYGON DEFINED BY THE POINTS (XP(I),YP(I)), 
C  FOR I FROM 1 TO NP.
C
C  THE INPUT POLYGON DOES NOT HAVE TO BE A CLOSED POLYGON, THAT IS
C  IT DOES NOT HAVE TO BE THAT (XP(1),YP(1) = (XP(NP,YP(NP)).
C
C----------------------------------------------------------------------
C
C  DETERMINE THE NUMBER OF POINTS TO LOOK AT (DEPENDING ON WHETHER THE
C  CALLER MADE THE LAST POINT A DUPLICATE OF THE FIRST OR NOT).
C
      if (xp(np).eq.xp(1) .and. yp(np).eq.yp(1)) then
        npts = np-1
      else
        npts = np
      end if

      inpoly2 = 0		! ASSUME POINT IS OUTSIDE

C --- ------------------------------------------------------------------
C --- CHECK TO SEE IF THE POINT IS ON THE POLYGON.
C --- ------------------------------------------------------------------

      do ipnt = 1,npts
         if (xpnt .eq. xp(ipnt) .and. ypnt .eq. yp(ipnt) ) then
	    inpoly2 = 1
	    goto 999		! EARLY EXIT
         endif
      enddo

C --- ------------------------------------------------------------------
C --- COMPUTE THE TOTAL ANGULAR CHANGE DESCRIBED BY A RAY EMANATING 
C --- FROM THE POINT (XPNT,YPNT) AND PASSING THROUGH A POINT THAT 
C --- MOVES AROUND THE POLYGON.
C --- ------------------------------------------------------------------

      anch = 0.

      inxt = npts
      xnxt = xp(npts)
      ynxt = yp(npts)
      anxt = atan2(ynxt-ypnt, xnxt-xpnt)

      do 100 ipnt=1,npts

         ilst = inxt
         xlst = xnxt
         ylst = ynxt
         alst = anxt

         inxt = ipnt
         xnxt = xp(inxt)
         ynxt = yp(inxt)
         anxt = atan2(ynxt-ypnt, xnxt-xpnt)

         adif = anxt-alst

         if (abs(adif) .gt. pi) adif = adif - sign(ttpi,adif)

         anch = anch + adif

 100  continue

C --- ------------------------------------------------------------------
C --- IF THE POINT IS OUTSIDE THE POLYGON, THE TOTAL ANGULAR CHANGE 
C --- SHOULD BE EXACTLY ZERO, WHILE IF THE POINT IS INSIDE THE POLYGON,
C --- THE TOTAL ANGULAR CHANGE SHOULD BE EXACTLY PLUS OR MINUS TWO PI.
C --- WE JUST TEST FOR THE ABSOLUTE VALUE OF THE CHANGE BEING LESS 
C --- THAN OR EQUAL TO PI.
C --- ------------------------------------------------------------------

      if (abs(anch) .ge. pi) inpoly2 = 1

 999  continue
      return
      end
