//************************************************************************************
// Module       : cff_wrappers_extern.h
// Date         : 2/17/05 (DLR)
// Copyright    : 2005-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : External declaration header for cff Fortran functions.
//                There should be a one-to-one correspondence between these
//                headers and their calls in cff_wrappers.cpp module.
// Derived From : none.
// Modifications:
//************************************************************************************
#include "gtypes.h"

extern "C" {
#if defined(_LINUX) 
void dmxm_(GDOUBLE C[], GDOUBLE A[], GINT *nai, GINT *naj, GDOUBLE B[], GINT *nbi, GINT *nbj, GINT *isz);
#elif defined(_AIX)
void dmxm (GDOUBLE C[], GDOUBLE A[], GINT *nai, GINT *naj, GDOUBLE B[], GINT *nbi, GINT *nbj, GINT *isz);
#else
void DMXM_(GDOUBLE C[], GDOUBLE A[], GINT *nai, GINT *naj, GDOUBLE B[], GINT *nbi, GINT *nbj, GINT *isz);
#endif

#if defined(_LINUX) 
void dmxv_(GDOUBLE y[], GINT *ny, GDOUBLE A[], GDOUBLE x[], GINT *nx, GINT *isz);
#elif defined(_AIX)
void dmxv (GDOUBLE y[], GINT *ny, GDOUBLE A[], GDOUBLE x[], GINT *nx, GINT *isz);
#else
void DMXV_(GDOUBLE y[], GINT *ny, GDOUBLE A[], GDOUBLE x[], GINT *nx, GINT *isz);
#endif

#if defined(_LINUX) 
void dmxdm_(GDOUBLE C[], GDOUBLE A[], GINT *nai, GINT *naj, GDOUBLE b[], GINT *nb, GINT *isz);
#elif defined(_AIX)
void dmxdm (GDOUBLE C[], GDOUBLE A[], GINT *nai, GINT *naj, GDOUBLE b[], GINT *nb, GINT *isz);
#else
void DMXDM_(GDOUBLE C[], GDOUBLE A[], GINT *nai, GINT *naj, GDOUBLE b[], GINT *nb, GINT *isz);
#endif

#if defined(_LINUX) 
void ddmxm_(GDOUBLE C[], GDOUBLE a[], GINT *na, GDOUBLE B[], GINT *nbi, GINT *nbj, GINT *isz);
#elif defined(_AIX)
void ddmxm (GDOUBLE C[], GDOUBLE a[], GINT *na, GDOUBLE B[], GINT *nbi, GINT *nbj, GINT *isz);
#else
void DDMXM_(GDOUBLE C[], GDOUBLE a[], GINT *na, GDOUBLE B[], GINT *nbi, GINT *nbj, GINT *isz);
#endif

#if defined(_LINUX)
void dzaxpby_(GDOUBLE z[], GDOUBLE x[], GDOUBLE *a, GDOUBLE y[], GDOUBLE *b, GINT *nxy, GINT *isz);
#elif defined(_AIX)
void dzaxpby (GDOUBLE z[], GDOUBLE x[], GDOUBLE *a, GDOUBLE y[], GDOUBLE *b, GINT *nxy, GINT *isz);
#else
void DZAXPBY_(GDOUBLE z[], GDOUBLE x[], GDOUBLE *a, GDOUBLE y[], GDOUBLE *b, GINT *nxy, GINT *isz);
#endif

#if defined(_LINUX) 
void dxaxpby_(GDOUBLE x[], GDOUBLE *a, GDOUBLE y[], GDOUBLE *b, GINT *nxy, GINT *isz);
#elif defined(_AIX)
void dxaxpby (GDOUBLE x[], GDOUBLE *a, GDOUBLE y[], GDOUBLE *b, GINT *nxy, GINT *isz);
#else
void DXAXPBY_(GDOUBLE x[], GDOUBLE *a, GDOUBLE y[], GDOUBLE *b, GINT *nxy, GINT *isz);
#endif

#if defined(_LINUX) 
void dzvxvpt_(GDOUBLE z[], GDOUBLE x[], GDOUBLE y[], GINT *nxy, GINT *isz);
#elif defined(_AIX)
void dzvxvpt (GDOUBLE z[], GDOUBLE x[], GDOUBLE y[], GINT *nxy, GINT *isz);
#else
void DZVXVPT_(GDOUBLE z[], GDOUBLE x[], GDOUBLE y[], GINT *nxy, GINT *isz);
#endif

#if defined(_LINUX) 
void dvvxvpt_(GDOUBLE x[], GDOUBLE y[], GINT *nxy, GINT *isz);
#elif defined(_AIX)
void dvvxvpt (GDOUBLE x[], GDOUBLE y[], GINT *nxy, GINT *isz);
#else
void DVVXVPT_(GDOUBLE x[], GDOUBLE y[], GINT *nxy, GINT *isz);
#endif

#if defined(_LINUX)
void ddot_(GDOUBLE *dot, GDOUBLE x[], GDOUBLE y[], GINT *nxy, GINT *isz);
#elif defined(_AIX)
void ddot (GDOUBLE *dot, GDOUBLE x[], GDOUBLE y[], GINT *nxy, GINT *isz);
#else
void DDOT_(GDOUBLE *dot, GDOUBLE x[], GDOUBLE y[], GINT *nxy, GINT *isz);
#endif

#if defined(_LINUX) 
void dcopy_(GDOUBLE x[], GDOUBLE y[], GINT *nxy, GINT *isz);
#elif defined(_AIX)
void dcopy (GDOUBLE x[], GDOUBLE y[], GINT *nxy, GINT *isz);
#else
void DCOPY_(GDOUBLE x[], GDOUBLE y[], GINT *nxy, GINT *isz);
#endif



}

