//************************************************************************************//
// Module       : gindex.hpp
// Date         : 7/9/01 (DLR)
// Copyright    : 2001-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                a global index object
// Derived From : none.
// Modifications:
//************************************************************************************//
#if !defined(GINDEX_HPP)
#define GINDEX_HPP
#include "gtypes.h"
#include <iostream.h>


class GIndex
{
// Private data:
private:

        GINT              ibeg_;
        GINT              iend_;
        GINT              istride_;
        GINT              ibase_;
        GINT              npad_;
        GINT              nlocal_;
        GINT              nglob_;


public:
                           GIndex(GINT ng, GINT nl, GINT ib, GINT ie, GINT inc, GINT npad) 
                           {nglob_=ng; nlocal_=MAX(nl,ie-ib+1); ibeg_=ib; iend_=ie; istride_=inc; npad_=npad; ibase_=0;}  
                           GIndex() {ibeg_=iend_=nglob_=nlocal_=ibase_=0; istride_=1; npad_=0;}
                           GIndex(const GIndex &i) {nglob_=i.nglob_;  nlocal_=i.nlocal_; ibeg_=i.ibeg_; iend_=i.iend_; 
                                                     istride_=i.istride_; npad_=i.npad_; ibase_=i.ibase_;}
  virtual                 ~GIndex(){};

         inline GIndex   &operator()(GINT ib, GINT ie, GINT inc, GINT ibs) {
                           ibeg_ = ib>=0?ib:0; iend_ = ie<nglob_?ie:nglob_-1; 
                           iend_ = iend_>=ibeg_?iend_:ibeg_; istride_=inc; ibase_=ibs; return *this;}
         inline GIndex   &operator()(GINT ng, GINT nl, GINT ib, GINT ie, GINT inc, GINT npad) {
                           nglob_ = ng>=0?ng:0; ibeg_ = ib>=0?ib:0; iend_ = ie<nglob_?ie:nglob_-1; 
                           iend_ = iend_>=ibeg_?iend_:ibeg_; nlocal_=MAX(nl,iend_-ibeg_+1); istride_=inc; npad_=npad; return *this;}
         inline GIndex   &operator=(const GIndex &i) {
                           nglob_=i.nglob_; nlocal_=i.nlocal_; ibeg_=i.ibeg_; iend_=i.iend_; 
                           istride_=i.istride_; npad_=i.npad_;  ibase_=i.ibase_; return *this;}
         inline GBOOL      operator==(const GIndex &i) { 
                             return (ibeg_  ==i.ibeg_  &&iend_ ==i.iend_  &&istride_==i.istride_&&
                                     nlocal_==i.nlocal_&&nglob_==i.nglob_ &&ibase_  ==i.ibase_);  }
         inline GIndex   &operator+(GINT i) {ibeg_ += i; iend_ += i; return *this;}


         friend ostream&   operator<<(ostream&str, const GIndex&i){
             str << "(" << i.szglobal() << "::" << i.szlocal() << ":" << i.beg() << ":" << i.end() << ":" << 
             i.stride() << ":" << i.pad() << ":" << i.base() << ")"; return str; }
         friend ostream&   operator<<(ostream&str, const GIndex*i){
             str << "(" << i->szglobal() << "::" << i->szlocal() << ":" << i->beg() << ":" << i->end() << ":" << 
             i->stride() << ":" << i->pad() << ":" << i->base() << ")"; return str; }

    
                   
         inline GINT           &beg() {return ibeg_;}
         inline const GINT     &beg() const {return ibeg_;}
         inline GINT           &end() {return iend_;}
         inline const GINT     &end() const {return iend_;}
         inline GINT           &szglobal() {return nglob_;}
         inline const GINT     &szglobal() const {return nglob_;}
         inline GINT           &szlocal () {return nlocal_;}
         inline const GINT     &szlocal () const {return nlocal_ ;}
         inline GINT           &stride() {return istride_;}
         inline const GINT     &stride() const {return istride_;}
         inline GINT           &pad() {return npad_;}
         inline const GINT     &pad() const {return npad_;}
         inline GINT           &base() {return ibase_;}
         inline const GINT     &base() const {return ibase_;}





};

#endif
