//************************************************************************************//
// Module       : gtvmatrix.hpp
// Date         : 7/9/01 (DLR)
// Copyright    : 2001-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                a template matrix object, whose data is composed of
//                variable length vectors.
// Derived From : LinOp.
// Modifications:
//************************************************************************************//
#if !defined(GTVMATRIX_HPP)
#define GTVMATRIX_HPP
#include <stdlib.h>
#include <memory.h>
#include <iomanip.h>
#include <iostream.h>
#include "gtypes.h"
#include "gtvector.hpp"
#include "linop.hpp"

#if !defined(GMatrix)
#  define GVMatrix GTVMatrix<GDOUBLE>
#endif

#if !defined(GBasisMatrix)
#  define GVBasisMatrix GTVMatrix<GQUAD>
#endif

//class T;
//template<class T> class GTVector;
template<class T> class GTVMatrix: public LinOp
{
public:
                          GTVMatrix();
                          GTVMatrix(const GINT , const GINT );
                          GTVMatrix(GIndex &s1,GIndex &s2);
                          GTVMatrix(GIndex &s1,GIndex &s2, GINT  **);
                          GTVMatrix(GIndex &s1,GIndex &s2, GINT  nUpper, GINT  nLower);
                          GTVMatrix(T *array, GINT  n1, GINT  n2);
                          GTVMatrix(const GTVMatrix<T> &);

                         ~GTVMatrix();

virtual  GTVMatrix<T>      operator=(const GTVMatrix<T> &);
virtual  void             operator=(T );
virtual  GTVMatrix<T>      operator*(GTVMatrix<T> )       ;
virtual  GTVector<T>      operator*(GTVector<T> )       ; // right multiplication: Matrix * Array
virtual  GTVMatrix<T>      operator*(T)                   ; // right multiplication: Matrix * const

virtual  GTVMatrix<T>      operator+(GTVMatrix<T>  ) ; // addition
virtual  GTVMatrix<T>      operator-(GTVMatrix<T>  ) ; // addition
virtual  GBOOL            Transpose(GTVMatrix<T> &);
virtual  GTVMatrix<T>      Transpose();
virtual  GBOOL            Inverse(GTVMatrix<T> &);
virtual  GTVMatrix<T>      Inverse();
virtual  GBOOL            isSymmetric();

inline virtual  T         &operator()(const GINT  i, const GINT  j ){
                          if ( i-beg(1) >= dim(1) || i < 0 || j-beg(2) >= dim(2) || j < 0  ) {
                            cout << "GTVMatrix<T>::&(): access error"<< endl;
                            exit(1);
                            }
                          GTVector<T> *v;
                          v = data[i-beg(1)];
                          if ( i < beg(1) || i > end(1) ) return ( fNULL=0 );
                          if ( j < v->GetIndex().beg() || j > v->GetIndex().end() ) return ( fNULL=0 );
                          return (*v)(j);}  //*(v->Data() + j - v->GetIndex().beg());}



inline  virtual  T        operator()(const GINT  i , const GINT  j ) const {
                          if ( i-beg(1) >= dim(1) || i < 0 || j-beg(2) >= dim(2) || j < 0  ) {
                            cout << "GTVMatrix<T>::&(): access error"<< endl;
                            exit(1);
                            }
                          GTVector<T> *v;
                          v = data[i-beg(1)];
                          if ( i < beg(1) || i > end(1) ) return (0.0 );
                          if ( j < v->GetIndex().beg() || j > v->GetIndex().end() ) return (0.0 );
                          return (*v)(j);}   //*(v->Data() + j - v->GetIndex().beg());}
                   
virtual  GIndex           GetIndex(GINT  idir) const ;
virtual  GBOOL            isDistributed();
virtual  GINT              tsize(GINT  idir);  // _total_ size = n_idir + n_idir_pad_
virtual  GINT              dim(GINT  idir) const;
virtual  GINT              beg(GINT  idir) const;
virtual  GINT              end(GINT  idir) const;

virtual  GTVector<T>     **Data() const;
virtual  GBOOL             Resize(GINT  Nx, GINT  Ny);
virtual  void              Zero();
  
         friend ostream&   operator<<(ostream &, const GTVMatrix<GDOUBLE> & );
         friend ostream&   operator<<(ostream &, const GTVMatrix<GQUAD> & );

private:

// Private methods:
void              DeleteDynamic();
GBOOL             ludcmp (T **&a, GINT  n, GINT  *&indx, T *d);
GBOOL             wludcmp(T **&a, GINT  n, GINT  *&indx, T *d);
GBOOL             lubksb (T **&a, GINT  n, GINT  *&indx, T b[]);
GINT               isamax(GINT  n, GDOUBLE *sx, GINT  incx);


// Private data:
GINT               n1;
GINT               n2;
GBOOL             bDistributed;
G_DATATYPE        dtype;
GC_DATATYPE       cdtype;

GIndex          gindex1;
GIndex          gindex2;
GINT             *jMap[2];  // bounding j-indices for compressed storage for each row, i
GTVector<T>     **data;
T                 fNULL;
#if defined(DO_BLAS_TIMING)
public:
        GDOUBLE            GetTime(GINT  i){if      ( i==0 ) return time_result;
                                          else if ( i==1 ) return time_result1;
                                          else if ( i==2 ) return time_result2; }
private:
        GDOUBLE            time_result;
        GDOUBLE            time_result1;
        GDOUBLE            time_result2;
#endif




};
# if defined(_LINUX) || defined(_AIX)
template class GTVMatrix<GDOUBLE>;
ostream &operator <<(ostream&, const GTVMatrix<GDOUBLE>&);
template class GTVMatrix<GQUAD>;
ostream &operator <<(ostream&, const GTVMatrix<GQUAD>&);
#  endif
#endif
