//************************************************************************************
// Module       : mtk.hpp
// Date         : 5/14/02 (DLR)
// Copyright    : 2002-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Namespace encapsulating C-style linear algebra methods
// Derived From : none.
// Modifications:
//************************************************************************************
#if !defined(MTK_HPP)
#define MTK_HPP

#include "gtvector.hpp"
#include "gtmatrix.hpp"
#if defined(MPI_GENERIC_DEFAULT)
#  include "mpi.h"
#endif

extern GINT     szCache_;
extern GDOUBLE  stmp[];


namespace MTK
{
    void    fvec_add           (GTVector<GDOUBLE> &x, GTVector<GDOUBLE> &y, GTVector<GDOUBLE> &ret);
    void    fvec_add_rep       (GTVector<GDOUBLE> &x, GTVector<GDOUBLE> &y);
    void    fvec_sub           (GTVector<GDOUBLE> &x, GTVector<GDOUBLE> &y, GTVector<GDOUBLE> &ret);
    void    fvec_sub_rep       (GTVector<GDOUBLE> &x, GTVector<GDOUBLE> &y);
    GDOUBLE fvec_dot           (GTVector<GDOUBLE> &x, GTVector<GDOUBLE> &y);
    void    fvec_copy          (GTVector<GDOUBLE> &x, GTVector<GDOUBLE> &y);
    void    fvec_const_prod_rep(GTVector<GDOUBLE> &x, GDOUBLE a);
    void    fvec_const_prod_sum_rep(GTVector<GDOUBLE> &x, GTVector<GDOUBLE> &y, GDOUBLE a, GDOUBLE b);
    void    fvec_const_prod    (GTVector<GDOUBLE> &x, GDOUBLE a, GTVector<GDOUBLE> &y);
    void    fmatvec_prod       (GTMatrix<GDOUBLE> &A, GTVector<GDOUBLE> &x, GTVector<GDOUBLE> &y);
    void    afmatvec_prod      (GTMatrix<GDOUBLE> &A, GDOUBLE *x, GINT  nx, GDOUBLE *y, GINT  ny);
    void    fmatvec_const_prod (GTMatrix<GDOUBLE> &A, GTVector<GDOUBLE> &x, GDOUBLE c, GTVector<GDOUBLE> &y);
    void    fmatmat_prod       (GTMatrix<GDOUBLE> &A, GTMatrix<GDOUBLE> &B, GTMatrix<GDOUBLE> &C);
    void    fvec_point_prod    (GTVector<GDOUBLE> &x, GTVector<GDOUBLE> &y, GTVector<GDOUBLE> &z);
    void    fvec_point_prod_rep(GTVector<GDOUBLE> &x, GTVector<GDOUBLE> &y);
//  void    fmatvec_prod_srep  (GTMatrix<GDOUBLE> &A, GTVector<GDOUBLE> &x, GDOUBLE cst, GTVector<GDOUBLE> &y);
    void    I2_X_D1            (GMatrix &D , GVector &x, GINT  N1, GINT  N2, GVector &y);
    void    D2_X_I1            (GMatrix &DT, GVector &x, GINT  N1, GINT  N2, GVector &y);
    void    Dg2_X_D1           (GMatrix &D1, GVector &Dg2, GVector &x, GVector &vtmp, GVector &y);
    void    D2_X_Dg1           (GMatrix &D2T, GVector &Dg1, GVector &x, GVector &vtmp, GVector &y);
    void    D2_X_D1            (GMatrix &D1 , GMatrix &D2T, GVector &x, GINT nx1, GINT nx2, 
                                GVector &tmp, GINT nt1, GINT nt2, GVector &y, GINT ny1, GINT ny2);

    void    qvec_add           (GTVector<GQUAD> &x, GTVector<GQUAD> &y, GTVector<GQUAD> &ret);
    void    qvec_add_rep       (GTVector<GQUAD> &x, GTVector<GQUAD> &y);
    void    qvec_sub           (GTVector<GQUAD> &x, GTVector<GQUAD> &y, GTVector<GQUAD> &ret);
    void    qvec_sub_rep       (GTVector<GQUAD> &x, GTVector<GQUAD> &y);
    GQUAD   qvec_dot           (GTVector<GQUAD> &x, GTVector<GQUAD> &y);
    void    qvec_copy          (GTVector<GQUAD> &x, GTVector<GQUAD> &y);
    void    qvec_const_prod_rep(GTVector<GQUAD> &x, GQUAD a);
    void    qvec_const_prod    (GTVector<GQUAD> &x, GQUAD a, GTVector<GQUAD> &y);
    void    qmatvec_prod       (GTMatrix<GQUAD> &A, GTVector<GQUAD> &x, GTVector<GQUAD> &y);
    void    qmatmat_prod       (GTMatrix<GQUAD> &C, GTMatrix<GQUAD> &A, GTMatrix<GQUAD> &B);
#if 0
    void    qmatvec_prod_srep  (GTMatrix<GQUAD> &A, GTVector<GQUAD> &x, GTVector<GQUAD> &y);
#endif
/////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////   BASIC routines   //////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////
    void basic_dxaxpby    (GDOUBLE x[], GDOUBLE a, GDOUBLE y[], GDOUBLE b, GINT nxy);
    void basic_dzaxpby    (GDOUBLE z[], GDOUBLE x[], GDOUBLE a, GDOUBLE y[], GDOUBLE b, GINT nxy);
    void basic_dmxv       (GDOUBLE y[], GINT ny, GDOUBLE A[], GDOUBLE x[], GINT nx);
    void basic_ddot       (GDOUBLE *dot, GDOUBLE y[], GDOUBLE x[], GINT nxy);
    void basic_dcopy      (GDOUBLE y[], GDOUBLE x[], GINT nxy);
    void basic_dzvxv_point(GDOUBLE z[], GDOUBLE x[], GDOUBLE y[], GINT nxy);
    void basic_dvvxv_point(GDOUBLE x[], GDOUBLE y[], GINT nxy);
    void basic_dmxDm      (GDOUBLE z[], GDOUBLE A[], GINT nxi, GINT nxj, GDOUBLE b[], GINT nb);
    void basic_dDmxm      (GDOUBLE C[], GDOUBLE b[], GINT nb, GDOUBLE A[], GINT nxi, GINT nxj);
    void basic_dmxm       (GDOUBLE C[], GDOUBLE A[], GINT nxi, GINT nxj, GDOUBLE B[], GINT nyi, GINT nyj);

    void basic_qxaxpby    (GQUAD   x[], GQUAD   a, GQUAD   y[], GQUAD   b, GINT nxy);
    void basic_qzaxpby    (GQUAD   z[], GQUAD   x[], GQUAD   a, GQUAD   y[], GQUAD   b, GINT nxy);
    void basic_qmxv       (GQUAD   y[], GINT ny, GQUAD   A[], GQUAD   x[], GINT nx);
    void basic_qdot       (GQUAD   *dot, GQUAD   y[], GQUAD   x[], GINT nxy);
    void basic_qcopy      (GQUAD   y[], GQUAD   x[], GINT nxy);
    void basic_qmxm       (GQUAD   C[], GQUAD A[], GINT nxi, GINT nxj, GQUAD B[], GINT nyi, GINT nyj);


    void cf_dxaxpby    (GDOUBLE x[], GDOUBLE a, GDOUBLE y[], GDOUBLE b, GINT nxy);
    void cf_dzaxpby    (GDOUBLE z[], GDOUBLE x[], GDOUBLE a, GDOUBLE y[], GDOUBLE b, GINT nxy);
    void cf_dmxv       (GDOUBLE y[], GINT ny, GDOUBLE A[], GDOUBLE x[], GINT nx);
    void cf_ddot       (GDOUBLE *dot, GDOUBLE y[], GDOUBLE x[], GINT nxy);
    void cf_dcopy      (GDOUBLE y[], GDOUBLE x[], GINT nxy);
    void cf_dzvxv_point(GDOUBLE z[], GDOUBLE x[], GDOUBLE y[], GINT nxy);
    void cf_dvvxv_point(GDOUBLE x[], GDOUBLE y[], GINT nxy);
    void cf_dmxm       (GDOUBLE C[], GDOUBLE A[], GINT nai, GINT naj, GDOUBLE B[], GINT nbi, GINT nbj);
    void cf_dmxDm      (GDOUBLE C[], GDOUBLE A[], GINT nxi, GINT nxj, GDOUBLE b[], GINT nb);
    void cf_dDmxm      (GDOUBLE C[], GDOUBLE b[], GINT nb, GDOUBLE A[], GINT nxi, GINT nxj);

    void cf_qxaxpby    (GQUAD   x[], GQUAD   a, GQUAD   y[], GQUAD   b, GINT nxy);
    void cf_qzaxpby    (GQUAD   z[], GQUAD   x[], GQUAD   a, GQUAD   y[], GQUAD   b, GINT nxy);
    void cf_qmxv       (GQUAD   y[], GINT ny, GQUAD   A[], GQUAD   x[], GINT nx);
    void cf_qdot       (GQUAD   *dot, GQUAD   y[], GQUAD   x[], GINT nxy);
    void cf_qcopy      (GQUAD   y[], GQUAD   x[], GINT nxy);
    void cf_qmxm       (GQUAD   C[], GQUAD   A[], GINT nai, GINT naj, GQUAD   B[], GINT nbi, GINT nbj);

#if defined(DO_MTK_TIMING)
    GDOUBLE   GetTime    () ;
    GDOUBLE   _MTKtstart;
    GDOUBLE   _MTKtime_result;

#endif
}

#endif

