//************************************************************************************//
// Module       : glopdw.hpp
// Date         : 2/14/02 (DLR)
// Copyright    : 2002-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                a geometry--free global gather/scatter operator; uses
//                a formulation that accepts GDWORD data and parses it
//                into HiWord and LoWord data.
// Derived From : none.
// Modifications:
//************************************************************************************//
#if !defined(GLOPDW_HPP)
#define GLOPDW_HPP

#include "elem2d.hpp"
#include "gtvector.hpp"
#include "gtbuffer.hpp"
#include "gttlist.hpp"
#include "gs.hpp"

#if defined(DO_GLOP_TIMING)
enum SETIMER_RESULT_T {SETTR_OP, SETTR_EXCH};
#endif

class GlOpDW: public GS 
{
public:
                  GlOpDW(GBOOL useHiWordData=FALSE);
                 ~GlOpDW();
                  GlOpDW(const GlOpDW &a);
GlOpDW             &operator=(const GlOpDW &);
                   

GCHandle          Init(GDWBuffer  *glob_index, GINT  maxindex);
GBOOL             DoOp (GDOUBLE *u,  GINT  ulen, G_OP op, GCHandle hand);
GVector           DoOp (GVector &u,  G_OP op, GCHandle hand);
GBOOL             DSOp (GVector **u,  GINT  nop, G_OP op, GCHandle hand);
GBOOL             DSOp (GVecList &u,   G_OP op, GCHandle hand);
#if defined (GENERALIZED_EXCHANGE)
GBOOL             DoOp (void *u,  GINT  ulen, GC_DATATYPE dtype, G_OP op, GCHandle hand);
#endif
GVector          *iMultiplicity(GINT  ie, GCHandle hand);
GBOOL             FreeHandle(GCHandle);

#if defined(DO_GLOP_TIMING)
GDOUBLE             GetTimes(SETIMER_RESULT_T type);
#endif

private:
// Private methods:
 
// Init-specific methods:
GCHandle          InitSort(GDWBuffer  *glob_index, GDWORD MaxNodes, 
                          GWBuffer  **&irPrBin, GWBuffer  **&irHiBin, 
                          GINT  &numRecvBins, GINT  &maxSharedNodes,
                          GINT  &PRrec_len  , GINT  &HIrec_len);
GINT              BinSort(GDWBuffer  *glob_indices,  
                          GIBuffer  *&bInRange_, GIBuffer  *&nInRange_, GDWBuffer  *&iWorkNodes_);

GBOOL             DoCommonNodeSort(GINT  maxSharedNodes, GINT  Proc_rec_length, GINT  HiWrd_rec_length,
                                   GDWBuffer  *Input[], GSBuffer   *procIDs, 
                                   GWBuffer   *ProcSortOutput[], GWBuffer  *HiWrdSortOutput[],
                                   const GINT  NumberOfListBuffers);
GBOOL             Repack(GWBuffer  **, GINT , GINT , GINT , GINT , GSBuffer  *&,
                         GWBuffer  **&, GINT  & );
GBOOL             GetRecord(GINT  index, GWBuffer  *rec_buff, GINT  max_length,
                            GWORD *iGlobal, GSHORT  **proc_buff, GSHORT  *num_procs);
GBOOL             BinFill(GDWBuffer  *nodelist, GDWBuffer  *bins[]);

// DoOp(1)-specific methods:
GBOOL             CombineLocal(GDOUBLE *u, GINT  n, GIBuffer  **ilocal, GINT  n_comb, G_OP op, GDOUBLE *&result);
GBOOL             SetGlobalNodeVal(GCHandle h, GDOUBLE *u, GINT  n, const GWORD  glNode, const GDOUBLE val);
GBOOL             Data_Exchange     (GCHandle h, GDOUBLE *send_data, GDOUBLE *&recv_data, GINT  &n_recv, GWBuffer  *&list);

#if defined (GENERALIZED_EXCHANGE)
DoOp(2)- specific methods:
GBOOL             CombineLocal(void *u, GINT  n, GC_DATATYPE dtype, GIBuffer  **ilocal, GINT  n_comb, G_OP op, void *&result);
GBOOL             SetGlobalNodeVal(GCHandle h, void *u, GINT  n, GC_DATATYPE dtype, GWORD glNode, void *val);
GBOOL             Data_Exchange     (GCHandle h, void *send_data, void *&recv_data, GINT  &n_recv, GC_DATATYPE dtype, GIBuffer  *&list);
#endif

// Handle-specific methods:
GCHandle          GetNewHandle();
GSHORT            HandleIndex(GCHandle h );
void              FreeHandleMem(GCHandle h );
GINT              GlobalToLocal(GWBuffer  *g2lbuffer,GINT  istart,  GWORD  global_index);
GBOOL             GetMultiplicity(GWBuffer  *inlist, GWBuffer  *&distinct_nodes, 
                                  GIBuffer   **&index_buffs);
GBOOL             ComputeGlobalMultiplicity(GCHandle hand, GVector *&global_mult_buff);

// General utilities:
GBOOL             IndexSort(GWBuffer  &);
GBOOL             IndexSort(GWBuffer  &, GIBuffer  &);
#if  !defined(GKEY_EQUAL_GINT )
GBOOL             IndexSort(GDWBuffer &, GIBuffer  &);
#endif
#if  !defined(GSHORT_EQUAL_GINT )
GBOOL             IndexSort(GSBuffer  &);
GBOOL             IndexSort(GSBuffer  &, GIBuffer  &);
#endif
void              DeleteDynamic();

// Private data:
GSHORT             NProcs;                            // number of processors
GINT               nMaxNodes;                       // total number of nodes distributed among all procs
GINT               numGlNode_buffs  [MAX_OPHANDLES];  // number of proc ids(and gl. node buffers), to exchange data with in DoOp
GINT               iLocalStack;                       // used for repeat call to GlobalToLocal 
GSHORT             rank;                              // rank of current processor
GSHORT             nUsedHandles;                      // number of handles from pool that are used
GBOOL              bHiWordUsed;                       // use high-word of node data?
GHBuffer          *opHandle;                          // global operation handle pool
GSBuffer          *iUsedHandles;                      // indices of used handles
GSBuffer          *srProc_list      [MAX_OPHANDLES];  // proc ids with which to exchange global node values
GWBuffer          **srGlNode_buffs   [MAX_OPHANDLES]; // repacked sorted data used by DoOp, containing global nodes to be exchanged with other procs
GWBuffer          *LocToGlob        [MAX_OPHANDLES];  // stores the global indices used in call to Init
GINT              **ig2l             [MAX_OPHANDLES]; // stores the global-to-local index transformations
GWBuffer          *glob_dups        [MAX_OPHANDLES];  // indices among the LocToGlob which are duplicated--for local operations
GIBuffer          **local_op_indices [MAX_OPHANDLES]; // those indices among the LocToGlob which are duplicated--for local operations
GVector           *gmultiplicity    [MAX_OPHANDLES];  // global id multiplicity
GVector           *vflat            [MAX_OPHANDLES];  // 'flat' vectors used for direct stiffness ops--one for each handle
GWBuffer          *g2lbuff;                           // used for repeat call to GlobalToLocal

#if defined(DO_GLOP_TIMING)
GDOUBLE              doop_time;
GDOUBLE              exch_time;
#endif

};
#endif

