//************************************************************************************//
// Module       : gpmelemid.hpp
// Date         : 6/9/05 (DLR)
// Copyright    : 2005-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the access methods and data associated with
//                generating an element/proc mapping for grid partitioning.
//                This class derives the map by using the element ids as
//                a space-filling curve, and dividing them up among the procs.
// Derived From : GPartMapper.
// Modifications:
//************************************************************************************//
#if !defined(GPMELEMID_HPP)
#define GPMELEMID_HPP

#include "gtypes.h"
#include "gelemlist.hpp"
#include "gcomm.hpp"
#include "gpartmapper.hpp"


class GPMElemID : public GPartMapper 
{
public:
                           GPMElemID(GElemList *gelemsv);
                          ~GPMElemID();

         GBOOL             GenerateMap(stGPartitionMap *&pm, GINT &nmax);            // Generate partition map data

private:
         GINT              GetSibCount(GIBuffer &isib, stGPartitionMap &epm, 
                                       stGPartitionMap *&gpm, GINT  &ngpm);          // Gets sibling count and indices of sibs in gpm



};

#endif
