//************************************************************************************//
// Module       : gpmsibpart.hpp
// Date         : 7/5/05 (DLR)
// Copyright    : 2005-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the access methods and data associated with
//                generating an element/proc mapping for sending sibling elements
//                to the proc where the parent will live when the siblings are
//                coarsened. This is done simply by trying to minimize the 
//                amount of communication for any one group of siblings; this
//                is not intended to act as a global load balancing partition mapper.
//                Note that here, the SetCoarsenables method _must_ be called with a 
//                non-NULL argument, and it is assumed that these coarsenable elements
//                represent only sibling elements that must be coarsened.
// Derived From : GPartMapper.
// Modifications:
//************************************************************************************//
#if !defined(GPMSIBPART_HPP)
#define GPMSIBPART_HPP

#include "gtypes.h"
#include "gelemlist.hpp"
#include "gcomm.hpp"
#include "gpartmapper.hpp"


class GPMSibPart : public GPartMapper 
{
public:
                           GPMSibPart(GElemList *gelemsv);
                          ~GPMSibPart();

         GBOOL             GenerateMap(stGPartitionMap *&pm, GINT &nmax);            // Generate partition map data

private:



};

#endif
