//************************************************************************************//
// Module       : vdbdata.cpp
// Date         : 8/4/03 (DLR)
// Copyright    : 2003-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the access methods and data associated with
//                defining a GASpAR voxel database record
// Derived From : none.
// Modifications:
//************************************************************************************//
#include "vdbdata.hpp"
#include <string>

//************************************************************************************
//************************************************************************************
// Constructor Method (1)
VDBData::VDBData()
:
hostkey_     (0),
hostrootkey_ (0),
hostid_      (0),
localid_     (0),
ancillary_   (0),
key_         (0),
proc_        (0)
{
  xPt_.x1 = xPt_.x2 = xPt_.x3 = 0.0;
} // end of constructor method (1)


//************************************************************************************
//************************************************************************************
// Destructor
VDBData::~VDBData()
{
}

//************************************************************************************
//************************************************************************************
// METHOD     :  << operator method (1)
// DESCRIPTION: output stream operator
// ARGUMENTS  :
//
// RETURNS    :
//************************************************************************************
ostream &operator<<(ostream &str, VDBData &a)
{
  GINT  i;
  i = a.localid();
  str << "Proc: " << a.proc_;
  str << " Key: " << a.key_;
  str << "  Host key: " << a.hostkey_;
  str << "  Host root key: " << a.hostrootkey_;
  str << "  Host ID: " << a.hostid_;
  str << "  Point ID: " << a.localid_;
  str << "  Point_typ: " << (GINT )COMPTYP(&i);
  str << "  Point_num: " << (GINT )COMPNUM(&i);
  str << "  Point_anc: " << (GINT )COMPANC(&i);
  str << "  Ancillary: " << a.ancillary_;
  str << "   X: (" << a.xPt_[0];
  for ( i=1; i<GDIM; i++ ) 
  str << ","    << a.xPt_[i];
  str << ")" << endl;

  return str;
} // end of operator <<
