//************************************************************************************//
// Module       : vdbdata.hpp
// Date         : 8/4/03 (DLR)
// Copyright    : 2003-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the access methods and data associated with
//                defining a GASpAR voxel database record 
// Derived From : none.
// Modifications:
//************************************************************************************//
#if !defined(GVDBDATA_HPP)
#define GVDBDATA_HPP

#include "gtypes.h"
#include <iostream.h>
#include <stdlib.h>
#include "point.hpp"

class VDBData
{
public:

                           VDBData();
                          ~VDBData();

inline   GKEY              &key() {                            // Get key data
  return key_; }
inline   GKEY              &hostkey() {                        // Get host element key; 
  return hostkey_; }
inline   GKEY              &hostrootkey() {                    // Get host element root key; 
  return hostrootkey_; }
inline   GINT              &localid() {                        // Get local id for point; 
  return localid_; }
inline   GINT              &hostid() {                         // Get host element id; 
  return hostid_; }
inline   Point3D           &point() {                          // Get geom. point data
  return xPt_; }
inline   GSHORT             &proc() {                           // Get proc id data
  return proc_; }
inline   GINT              &ancillary() {                      // Get ancillary data
  return ancillary_; }
         friend ostream&   operator<<(ostream&, VDBData &);    // Output stream operator

  inline GBOOL             operator==(VDBData &p) 
  { return ( key_   ==p.key_    && hostkey_==p.hostkey_ && hostrootkey_==p.hostrootkey_
          && hostid_==p.hostid_ && localid_==p.localid_ && xPt_        ==p.xPt_ 
          && proc_  ==p.proc_ && ancillary_==p.ancillary_ ); }

  inline GBOOL             operator!=(VDBData &p) 
  { return (!this->operator==(p)); }

  inline VDBData           operator=(VDBData &p) 
  { key_   =p.key_    ; hostkey_=p.hostkey_ ; hostrootkey_=p.hostrootkey_;
    hostid_=p.hostid_ ; localid_=p.localid_ ; xPt_        =p.xPt_; 
    proc_  =p.proc_ ; ancillary_=p.ancillary_; return *this; }

private:

         // Member data:
         GKEY              key_;
         GKEY              hostkey_;
         GKEY              hostrootkey_;
         GINT              hostid_;
         GINT              localid_;
         GINT              ancillary_;
         Point3D           xPt_;                                            
         GSHORT             proc_;

};

#endif
