//************************************************************************************//
// Module       : gasparFileIO.cpp
// Date         : 8/02/02 (RMP)
// Copyright    : 2002-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                Gaspar file IO.
// Derived From : none.
// Modifications:
//************************************************************************************//


#include "gasparFileIO.hpp"

const char* GasparFileIO::DTYPE_META_NAME = "DataType";
const char* GasparFileIO::THIS = "GasparFileIO";


//************************************************************************************
//************************************************************************************
// METHOD     : openFile() method 1
// DESCRIPTION: Opens an existing HDF file in read only mode. 
// ARGUMENTS  : fileNameIn  : The name of the file to open.
//              fileIn      : The GasparFile object with which to open the file. 
// RETURNS    : TRUE on success; else FALSE, if the file to open does not exit in the
//              current directory or cannot be opened for any reason.
//************************************************************************************

GBOOL GasparFileIO::openFile(GasparFile* inFile, const FILE_ACCESS accessIn){  
  
  file = inFile;
  inFile = NULL;

  if(!file->open(accessIn)){
    cerr << THIS << "::openFile() failed." << endl;
    file = NULL;
    return FALSE;
  }
 
  setOpenStatus(TRUE);
  return TRUE;
}
//end of method openFile() method 1



//************************************************************************************
//************************************************************************************
// METHOD     : openHDF()
// DESCRIPTION: Opens an existing HDF file in read only mode. 
// ARGUMENTS  : fileNameIn  : The name of the file to open.
//              fileIn      : The GasparFile object with which to open the file. 
// RETURNS    : TRUE on success; else FALSE, if the file to open does not exit in the
//              current directory or cannot be opened for any reason.
//************************************************************************************

GBOOL GasparFileIO::openHDF(const char* fileNameIn, const FILE_ACCESS accessIn, IO_TYPE fType, IO_TYPE dType, MPI_Comm commIn){  
  
  file = new HDFFile(fileNameIn, fType, dType, commIn);

  if(!file->open(accessIn)){
    cerr << THIS << "::openFile() failed." << endl;
    file = NULL;
    return FALSE;
  }
 
  setOpenStatus(TRUE);
  return TRUE;
}
//end of method openHDF()


//************************************************************************************
//************************************************************************************
// METHOD     : close()
// DESCRIPTION: Closes an existing file opened with a call to one of the openXX()
//              methods.  
// RETURNS    : TRUE on success; else FALSE if the file cannot be closed.
//************************************************************************************
GBOOL GasparFileIO::closeFile(){

  if(!isOpen()){
    return TRUE;
  }

  if(!file->close()){
    cerr << THIS << "::close() failed." << endl;
    return FALSE;
  }

  setOpenStatus(FALSE);
  return TRUE;
}
//end of method close() 

  




