//************************************************************************************//
// Module       : gbin_reader.hpp
// Date         : 10/17/02 (DLR)
// Copyright    : 2002-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                the object that reads a GASpAR binary data file
// Derived From : GBinStream
// Modifications:
//************************************************************************************//
#if !defined(GBIN_READER_HPP)
#define GBIN_READER_HPP 
#include "gtypes.h"
#include "gdd_file.h"
#include "gbin_stream.hpp"
#include "point.hpp"
#include <iostream.h>
#include <fstream.h>

class GBinReader: public GBinStream
{
public:
                          GBinReader(GBOOL isCollective=FALSE, GBOOL isIndependent=TRUE, GSHORT  ioTaskID=0);
//                        GBinReader(const GBinReader &);
                         ~GBinReader();

         enum             GBR_TypeSz {GBR_GINT =0, GBR_GSHORT , GBR_GDOUBLE, GBR_ELEM_SZ, GBR_GFPOS_SZ};

         GBOOL            Open(const char *);
         void             Close();
         GINT             GetDatatypeSz(GBR_TypeSz itype);
         GINT             GetNumDataSets();
         char            *GetMetaDesc();
         GINT             GetNumMeta();
         GDOUBLE         *GetMeta();
         const char      *GetLabel(GINT  idataset);
         GINT             GetNumTags(GINT  idataset);
         GDOUBLE         *GetTags(GINT  idataset);
         GFPOS            GetOffsets(GINT  idataset);
         ELEMTYPE         GetElemTypes(GINT  idataset);
         GINT             GetRank(GINT  idataset);
         GINT             GetDims(GINT  idataset, GINT  idir);
         GINT            *GetDims(GINT  idataset);
         GINT             GetCoordDims(GINT  idataset, GINT  idir);
         Point3D         *GetVert(GINT  idataset);
         GINT             GetNumVert(GINT  idataset);
         GDOUBLE         *GetGridData (GINT  idataset, GINT  idir, GDOUBLE *x, GINT  n);
         GDOUBLE         *GetFieldData(GINT  idataset, GDOUBLE *data, GINT  n);
         GDOUBLE         *GetFieldData(const char *label, GINT  ids_start, GDOUBLE *data, GINT  n);

private:
//    methods:
         GBOOL            GetFileInfo();
         GBOOL            GetDSInfo(GINT  dsid);
         GBOOL            CreateDynamic(GINT  ndatasets);
         void             DeleteDynamic();

//    data:
         GINT           ndatasets_;
         GINT           *nd_;
         GSHORT         *procid_;
         GINT           *nvv_;
         GINT           *nTag_;
         GINT4BYTE      nMeta_;
         GDOUBLE        *fMeta_;
         GDOUBLE        **fTag_;
         GFPOS          *dsoffsets_;
         GFPOS          *dataoffsets_;
         GFPOS          *coordoffsets_;
         ELEMTYPE       *elemtps_;
         GINT           **idims_;
         GINT           **cdims_;
         Point3D        **Vert_;     
         char           **sTag_;   
         char           *sMeta_;   
         char           *identifier_;   
 
};

#endif
