//************************************************************************************
// Module       : gios.hpp
// Date         : 12/10/02 (DLR)
// Copyright    : 2002-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Namespace encapsulating file opening modes
// Derived From : none.
// Modifications:
//************************************************************************************
#if !defined(GIOS_HPP)
#define GIOS_HPP

#include "gtypes.h"
#if defined(MPI_IO_DEFAULT)
#  include "mpi.h"
#endif


namespace gios
{
#if defined(MPI_IO_DEFAULT)
  GIOS_MODE app       = MPI_MODE_APPEND;
  GIOS_MODE ate       = MPI_MODE_APPEND;
  GIOS_MODE binary    = 0;
  GIOS_MODE in        = MPI_MODE_RDONLY;
  GIOS_MODE nocreate  = 0;
  GIOS_MODE noreplace = MPI_MODE_EXCL;
  GIOS_MODE out       = MPI_MODE_WRONLY;
  GIOS_MODE trunc     = 0;
#else
  GIOS_MODE app       = ios::app;
  GIOS_MODE ate       = ios::ate;
  GIOS_MODE binary    = ios::binary;
  GIOS_MODE in        = ios::in;
  GIOS_MODE nocreate  = ios::nocreate;
  GIOS_MODE noreplace = ios::noreplace;
  GIOS_MODE out       = ios::out;
  GIOS_MODE trunc     = ios::trunc;
#endif
} // end of namespace gios

#endif

