function y=insescape(x,c)
%
% y=insescape(x,'c')
%
% Insert '\' ahead of 'c' (default '_') in string x.
% x can be a cell array.
%
if nargin<2
   c='_';
end
if iscell(x)
   l=length(x);
else
   x={x};
   l=1;
end
for n=1:l
   f=find(x{n}==c);		% find characters
   o=0;				% offset
   for k=1:length(f)		% loop over characters
      m=f(k)+o;			% insert '\' ahead of character
      x{n}=[x{n}(1:m-1) '\' x{n}(m:end)];
      o=o+1;			% increment offset
   end
end
if l==1
   y=x{1};
else
   y=x;
end
