%
% Linear advection-diffusion analysis
%
owd=pwd;			% old (current) working directory
cd ~/sem/gaspar2d/test/data/results/liadvdif/
dprefs={'galump_na_n' 'galump_ad_n' 'gamelt_ad_n'};
nexps=length(dprefs);		% no. experiments
ddegs={5:2:15 7:2:15 5:2:13};	% degrees in subdirectories
iexp=1;				% experiment to analyze
ndeg=length(ddegs{iexp});	% no. degrees
if ~exist('u','var')
   for m=1:ndeg			% loop over degrees
      expname=[dprefs{iexp} int2str(ddegs{iexp}(m))];
      d{m}=dir(expname);	% get all files for this experiment
      n=0;			% time index
      for l=1:length(d{m})	% loop over files:
         if strfind(d{m}(l).name,expname)==1
            n=n+1;		% time index
            [fileinfo{n,m} elems{n,m} u{n,m}]=gbin_input([expname filesep d{m}(l).name]);
            disp(sprintf('Inputting %s',[expname filesep d{m}(l).name]))
         end			% found expname starting at 1 of filename
      end
      lt(m)=n;			% length of time series
      for n=1:lt(m)		% loop over time
         dt{m}(n)=fileinfo{n,m}.fmeta(10);
         t{m}(n)=fileinfo{n,m}.fmeta(11);
      end
   end
end
s = .4/(2*pi);			% width parameter
nu=fileinfo{1,1}.fmeta(23);	% diffusivity
if ~exist('uenorm','var')
for m=1:ndeg			% loop over degrees
   for n=1:lt(m)		% loop over time:
      ut=perGauss(elems{n,m},[],[.5 s .5 s nu],t{m}(n),'[t 0]');
      ue=biopelem(ut,u{n,m},'minus','Va','V1');
      uenorm{m}(n,1:2)=statelem(elems{n,m},ue,'VaminusV1');
      utnorm=statelem(elems{n,m},ut,'Va');
      uenorm{m}(n,1:2)=uenorm{m}(n,1:2)./utnorm;
      disp(sprintf('Assigning error for degree %d time %9.3e',ddegs{iexp}(m),t{m}(n)))
   end
   uenormm(m,1:2)=mean(uenorm{m}(:,1:2));
end
end
figure(1)
ma='osd^v><ph';			% markers
nma=length(ma);			% no. markers
semilogy(t{1},uenorm{1}(:,2),'ko-')
for m=2:ndeg			% loop over degrees
   line(t{m},uenorm{m}(:,2),'Color','k','Marker',ma(1+mod(m-1,nma)))
end
figure(2)			% plot time-mean error norms
semilogy(ddegs{iexp},uenormm,'x-')
eval(['cd ' owd])
