function h=quivelem(elems,u,ifig)
%
% Given structures elems and u (e.g., from gbin_input),
% create a quiver plot of (u.V1,u.V2) and a surf plot
% of u.Pr in figure ifig.  Labels axes by l2 errors from u.??A.
% Return h{1:elems.n,1:2}, handles to all the graphics
% objects.
%
figure(ifig)				% set current figure
clf					% clear figure
hold on					% don't erase previous plots
e=zeros(1,3);				% initialize l2 error
xt = [];				% x ticks
yt = [];				% y ticks
for i=1:elems.n				% loop over elements
   j = u.Pric(i);			% assign pointer to element node set
   h{i,1}=surf(elems.x{j}(:,:,1),elems.x{j}(:,:,2),u.Pr{i});
   e(3)=e(3)+norm(u.Pr{i}-u.PrA{i})^2;	% accumulate l2 error
   j = u.V1ic(i);			% assign pointer to element node set
   h{i,2}=quiver(elems.x{j}(:,:,1),elems.x{j}(:,:,2),u.V1{i},u.V2{i});
   e(1)=e(1)+norm(u.V1{i}-u.V1A{i})^2;	% accumulate l2 error
   e(2)=e(2)+norm(u.V2{i}-u.V2A{i})^2;	% accumulate l2 error
   xt = [xt;elems.x{j}(:,1,1)];		% accumulate x ticks
   yt = [yt elems.x{j}(1,:,2)];		% accumulate y ticks
end
axis equal				% use same scale, all axes
axis tight				% tighten axes limits to data
colormap(rwbmap(64))			% nice color
daspect([1 1 2])			% scale Pr differently from V
grid on					% show node grid lines
orient tall				% fill printed page
orient landscape			% rotate 90 deg
set(gca,'XTick',sort(unique(xt)),'YTick',sort(unique(yt)))
shading interp				% symmetrize colors
view(3)					% default 3D view
xlabel(sprintf('{%s} (%s_2=%7.1e)','\itu','\epsilon',sqrt(e(1))))
ylabel(sprintf('{%s} (%s_2=%7.1e)','\itv','\epsilon',sqrt(e(2))))
zlabel(sprintf('{%s} (%s_2=%7.1e)','\itp','\epsilon',sqrt(e(3))))
