//************************************************************************************//
// Module       : ilaplacian.hpp
// Date         : 2/26/03 (DLR)
// Copyright    : 2003-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                the inverse of the weak Laplacian operator.
// Derived From : LinOp.
// Modifications:
//************************************************************************************//
#if !defined(ILAPLACIANOP_HPP)
#define ILAPLACIANOP_HPP
#include "linop.hpp"
#include "helmholtzop.hpp"
#include "defquad2d.hpp"
#include "rectquad2d.hpp"
#include "diagop.hpp"

class iLaplacianOp: public LinOp
{
public:
                           iLaplacianOp();
                           iLaplacianOp(LinOp *A);
                           iLaplacianOp(Elem2D *e);
//                         iLaplacianOp(const iLaplacianOp &);
                          ~iLaplacianOp();

         GVector           operator*(GVector) ; // Multiply precond by right-vector
         void              OpVec_prod(GVector &q, GVector &ret);
         void              SetConst(GDOUBLE clc);
         void              SetConst(GDOUBLE clc1, GDOUBLE clc2);
         void              SetElem(Elem2D *e);


private:
         GBOOL             DefmQuadH();
         GBOOL             RectQuadH();
         GBOOL             TriangleH();
         GBOOL             ComputeOp();

         GINT              N1;     // 1-size 
         GINT              N2;     // 2-size 
         GINT              NN;     // 1 X 2 - size 
         GDOUBLE           lc1;    // Laplacian-multiplicative constant
         GDOUBLE           lc2;    // Laplacian-multiplicative constant
         Elem2D           *elem;
         GMatrix          *L;
         GMatrix          *iL;


};

#endif
