//************************************************************************************//
// Module       : ipoint.cpp
// Date         : 8/20/03 (DLR)
// Copyright    : 2003-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the access methods and data associated with
//                defining an GINT  point 
// Derived From : none.
// Modifications:
//************************************************************************************//
#if !defined(IPOINT_HPP)
#define IPOINT_HPP

#include "gtypes.h"
#include <iostream.h>
#include <stdlib.h>
#include <math.h>

class IPoint
{
public:
                  IPoint(); 
                 ~IPoint();
  friend ostream& operator<<(ostream &, IPoint &);

  inline GBOOL    operator==(IPoint &p) 
  { return (p.i1==i1 && p.i2==i2 && p.i3==i3); }

  inline GBOOL    operator!=(IPoint &p) // Add 'fuzziness' to equality check
  { return !this->operator==(p); }

  inline void  operator=(IPoint &p)
  { i1 = p.i1; i2 = p.i2; i3 = p.i3;}

  inline void  operator=(GINT  f)
  { i1 = i2 = i3 = f; }

  inline GINT  &operator()(GINT  i)
  { if ( i<0 || i>=3 ) { cout << "IPoint::(): access error; bad index:" << i << endl; exit(1); }
    return *pix_[i]; }

  inline GINT  &operator[](GINT  i)
  { if ( i<0 || i>=3 ) { cout << "IPoint::[]: access error; bad index:" << i << endl; exit(1); }
    return *pix_[i]; }

  GINT       i1;
  GINT       i2;
  GINT       i3;
  GINT       *pix_[3];

};

#endif
