//************************************************************************************//
// Module       : laplacianop.hpp
// Date         : 6/4/02 (DLR)
// Copyright    : 2002-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                the weak Laplacian linear operator
// Derived From : LinOp.
// Modifications:
//************************************************************************************//
#if !defined(LAPLACIANOP_HPP)
#define LAPLACIANOP_HPP

#include "linop.hpp"
#include "elem2d.hpp"

class LaplacianOp: public LinOp 
{
public:
                           LaplacianOp();
                           LaplacianOp(Elem2D *e);
//                         LaplacianOp(const LaplacianOp &);
                          ~LaplacianOp();

         GVector           operator*(GVector) ; // Multiply operator on the RHS by vector
         void              OpVec_prod(GVector &x, GVector &ret);
         void              SetElem(Elem2D *);
         Elem2D            *GetElem();
         void              SetConst(GDOUBLE c);
         void              SetConst(GDOUBLE c1, GDOUBLE c2);

//       friend ostream&   operator<<(ostream&, const LaplacianOp&);

private:
         GBOOL             DefmQuadOp(GVector *x, GVector *newx);
         GBOOL             RectQuadOp(GVector *x, GVector *newx);
         GBOOL             TriangleOp(GVector *x, GVector *newx);
  
         GDOUBLE           hC1;
         GDOUBLE           hC2;
         Elem2D           *elem;

};

#endif
