//************************************************************************************//
// Module       : linop.cpp
// Date         : 6/4/02 (DLR)
// Copyright    : 2002-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                the linear operator interface class. This pure virtual
//                class is to represent all those operators that
//                derive from the geometry of the input element
//                primarily through the weak (integrated) forms.
// Derived From : none.
// Modifications:
//************************************************************************************//
#include "linop.hpp"


//************************************************************************************
//************************************************************************************
// constructor method (1)
LinOp::LinOp()
:
mask        (NULL)
{
} // end of constructor (1)


//************************************************************************************
//************************************************************************************
// METHOD     : SetMask 
// DESCRIPTION: Sets mask
// ARGUMENTS  : GVector with vector arg.
// RETURNS    : none
//************************************************************************************
void LinOp::SetMask(GVector *m)
{
  mask = m;
} // end of SetMask

#if 0
//************************************************************************************
//************************************************************************************
// METHOD     : GatherScatterProd
// DESCRIPTION: Performs operator-vector product and then does a 
//              gather scatter (direct stiffness summation) of the result
// ARGUMENTS  : GVector &  : reference to RHS vector
//              GlOp     *  : pointer to comm object
//              GCHandle    : handle to already initialized comm object.
//                            If GlOp==NULL, no gather/scatter is done.
//                              
// RETURNS    : GVector. Faliure will occur if comm==NULL and the operation fails 
//              (e.g., due to an invalid handle.)
//************************************************************************************
GVector LinOp::GatherScatterProd(GVector  &b, GlOp *comm, GCHandle h) const
{
  GIndex   *sei=b.GetIndex();
  GVector newb(*sei);

  if ( comm == NULL )
  {
    newb = b;
    return newb;
  }

  newb = (*this) * b;
  if ( !comm->DoOp(newb.Data(), newb.dim(), G_OP_SUM, h) )
  {
    cout << "LinOp::GatherScatterProd: gather/scatter failure" << endl;
    exit(1);
  }

  return newb;

} // end of method GatherScatterProd
#endif
