//************************************************************************************//
// Module       : linop.hpp
// Date         : 6/4/02 (DLR)
// Copyright    : 2002-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                the linear operator interface class. This pure virtual
//                class is to represent all those operators that 
//                derive from the geometry of the input element 
//                primarily through the weak (integrated) forms.
// 
// Derived From : none.
// Modifications:
//************************************************************************************//
#if !defined(LINOP_HPP)
#define LINOP_HPP


#include "gtypes.h"
#include "gtvector.hpp"
 
class Elem2D;

class LinOp 
{
public:
                           LinOp();
                           LinOp(LinOp *){};
                           LinOp(Elem2D*){};
virtual                   ~LinOp(){};

virtual  GVector          operator*(GVector){cout << "LinOp::*: illegal entry; check derived operator API" 
                                                    << endl; exit(1); GVector v; return v;} 
                           // Could not make \* pure virtual if we want GTMatrix to be a LinOp
virtual  void              OpVec_prod(GVector &x, GVector &ret)
                                              {cout << "LinOp::OpVec_prod: illegal entry; check derived operator API" 
                                                    << endl; exit(1); } 
 
virtual  void              SetConst(GDOUBLE c)
                                              {cout << "LinOp::SetConst: illegal entry; check derived operator API" 
                                                    << endl; exit(1); } 
virtual  void              SetElem()
                                              {cout << "LinOp::SetElem: illegal entry; check derived operator API" 
                                                    << endl; exit(1); } 
virtual  Elem2D            *GetElem()
                                              {cout << "LinOp::GetElem: illegal entry; check derived operator API" 
                                                    << endl; exit(1); return NULL;} 
virtual  GINT              GetNumIntermedProd()
                                              {cout << "LinOp::GetIntermedProd: illegal entry; check derived operator API" 
                                                    << endl; exit(1); return 0; } 
virtual  LinOp             *GetIntermedOp()
                                              {cout << "LinOp::GetIntermedOp: illegal entry; check derived operator API" 
                                                    << endl; exit(1); return NULL; } 
virtual  GVector          *GetIntermedProd(GINT  itag)
                                              {cout << "LinOp::GetIntermedProd: illegal entry; check derived operator API" 
                                                    << endl; exit(1); return NULL; } 
virtual  void              SetMask(GVector *m);


protected:
         GVector          *mask;

};

#endif
