//************************************************************************************//
// Module       : point.cpp
// Date         : 8/20/03 (DLR)
// Copyright    : 2003-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the access methods and data associated with
//                defining a geometric point
// Derived From : none.
// Modifications:
//************************************************************************************//
#include "point.hpp"
#include <string>

//************************************************************************************
//************************************************************************************
// Constructor Method (1) 
Point::Point()
:
gdim_     (3),
eps_      (10.0*TINY),
x1        (0.0),
x2        (0.0),
x3        (0.0)
{
  px_[0] = &x1;
  px_[1] = &x2;
  px_[2] = &x3;
} // end of constructor method (1)


//************************************************************************************
//************************************************************************************
// Constructor Method (2)
Point::Point(GDOUBLE e)
:
gdim_     (3),
eps_        (e),
x1        (0.0),
x2        (0.0),
x3        (0.0)
{
  px_[0] = &x1;
  px_[1] = &x2;
  px_[2] = &x3;
} // end of constructor method (2)


//************************************************************************************
//************************************************************************************
// Destructor
Point::~Point()
{
}

//************************************************************************************
//************************************************************************************
// METHOD     :  << operator method
// DESCRIPTION: output stream operator
// ARGUMENTS  :
//
// RETURNS    :
//************************************************************************************
ostream &operator<<(ostream &str, Point &a)
{
  GINT  i;

  str << "("  << a[0];
  for ( i=1; i<a.GetDim(); i++ )
  str << ", " << a[i];
  str << ")";
  return str;
} // end of operator <<
