//************************************************************************************//
// Module       : siforce.cpp
// Date         : 12/4/02 (DLR)
// Copyright    : 2002-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                defining a (collocated) forcing function. This
//                is the base class for all such forcing funtions.
// Derived From : none
// Modifications:
//************************************************************************************//
#include "evforce.hpp"


//************************************************************************************
//************************************************************************************
// Constructor Method (1)
SIForce::SIForce()
: 
rank_        (2),
NN_          (0),
dt_          (0),
rho_         (1.0),
elem         (NULL)
{
  idims_[0] = idims_[1] = idims_[2] = 0;
} // end of constructor method (1)


//************************************************************************************
//************************************************************************************
// Constructor Method (2)
SIForce::SIForce(Elem2D *e)
:
rank_        (2),
NN_          (0),
dt_          (0),
rho_         (1.0),
elem         (e)
{
  idims_[0] = elem->GetOrder(1)+1;
  idims_[1] = elem->GetOrder(2)+1;
  idims_[2] = 1;
  NN_       = idims_[0]*idims_[1]*idims_[2];
} // end of constructor method (2)



//************************************************************************************
//************************************************************************************
// Destructor
SIForce::~SIForce()
{
}

//************************************************************************************
//************************************************************************************
// METHOD     : SetElem
// DESCRIPTION: Sets field element
// ARGUMENTS  : e: element pointer
// RETURNS    :
void  SIForce::SetElem(Elem2D *e)
{
  if ( e == NULL ) {
    cout << "SIForce::SetElem: NULL element" << endl;
    exit(1);
  }
  elem  = e;
  rank_ = 2;
  idims_[0] = elem->GetOrder(1)+1;
  idims_[1] = elem->GetOrder(2)+1;
  idims_[2] = 1;
  NN_       = idims_[0]*idims_[1];
} // end of method SetElem


//************************************************************************************
//************************************************************************************
// METHOD     : SetTimeStep
// DESCRIPTION: Sets time step
// ARGUMENTS  : f: time step
// RETURNS    :
void  SIForce::SetTimeStep(const GDOUBLE f)
{
  dt_ = f;
} // end of method SetTimeStep


//************************************************************************************
//************************************************************************************
// METHOD     : SetDensity
// DESCRIPTION: Sets const density
// ARGUMENTS  : f: density
// RETURNS    :
void  SIForce::SetDensity(GDOUBLE f)
{
  rho_ = f;
} // end of method SetDensity

