//************************************************************************************//
// Module       : uzawalapop.hpp
// Date         : 2/26/03 (DLR)
// Copyright    : 2003-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                the Laplacian operator derived from the Uzawa
//                decompoosition of the discrete form of the _steady_
//                Stokes equations where the pressure resides
//                on a different grid than the velocity, within
//                the same element. It is intended to act on the
//                p-quantity in the p Div v term. Its form is
//                  D1 L^-1 D1^T  + D2 L^-1 D2^T
//                where L is the discrete Laplacian, and Di are the 
//                weak pdV derivative operators defined in StokesOp.
//                velem and pelem are the elements where the 
//                v-quantity  and p-quantity reside, respectively 
//                
// Derived From : LinOp.
// Modifications:
//************************************************************************************//
#if !defined(UZAWALAPOP_HPP)
#define UZAWALAPOP_HPP

#include "linop.hpp"
#include "elem2d.hpp"
#include "massop.hpp"
#include "stokesop.hpp"
#include "ilaplacianop.hpp"

class UzawaLapOp: public LinOp 
{
public:
                           UzawaLapOp();
                           UzawaLapOp(Elem2D *ve, Elem2D *pe);
//                         UzawaLapOp(const UzawaLapOp &);
                          ~UzawaLapOp();

         GVector           operator*(GVector) ; // Multiply operator on the RHS by vector
         void              OpVec_prod(GVector &x, GVector &ret);
         void              SetConst(GDOUBLE c);
         void              SetElem(Elem2D *ve, Elem2D *pe);
         void              SetMask(GVector *m);
         void              SetVBdyData (GINT  idir, GVector *vb, GINT  *indices);

//       friend ostream&   operator<<(ostream&, const UzawaLapOp&);

private:
         GBOOL             QuadOp(GVector *x, GVector *newx);
         GBOOL             TriangleOp(GVector *x, GVector *newx);
         void              DeleteDynamic();
         void              Init(Elem2D *ve, Elem2D *pe);
  
         GDOUBLE             mConst;
         GINT             *ibdy;
         Elem2D           *velem;
         Elem2D           *pelem;
         GVector          *vtmpp0;
         GVector          *vtmpv0;
         GVector          *vtmpv1;
         GVector          *vbdy[3];
         GVector          *mask;
         iLaplacianOp     *iL;
         StokesOp         *pD1;
         StokesOp         *pD2;
         StokesOp         *pDT1;
         StokesOp         *pDT2;

};

#endif
