//************************************************************************************//
// Module       : pcpoint_jacobi.cpp
// Date         : 1/23/02 (DLR)
// Copyright    : 2002-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                a point Jacobi preconditioner object
// Derived From : none.
// Modifications:
//************************************************************************************//
#include "pcpoint_jacobi.hpp"
#include <stdlib.h>


//************************************************************************************
//************************************************************************************
// Constructor Method (1)
PCPointJacobi::PCPointJacobi(LinOp *AA)
:        SEPrecond(AA)
{
} // end of constructor method (1)


//************************************************************************************
//************************************************************************************
// Destructor
PCPointJacobi::~PCPointJacobi()
{
}


//************************************************************************************
//************************************************************************************
// multiplication of preconditioner on the RHS by a vector
GVector  PCPointJacobi::operator*(GVector &r)  const
{

  GVector  newr(r.dim());
  return newr;

#if 0
  if ( A == NULL )
  {
     cout << "PCPointJacobi::*: NULL Associated matrix" << endl;
     exit(1);
  }
  GINT     i, j;
  GIndex   *sei1=A->GetIndex(1), *sei2=A->GetIndex(2), *ri=r.GetIndex();
  GVector  newr(*sei1);


  // Find subspace of A that is spanned by r, take
  // diagonal. This is the Block Jacobi
  // preconditioner, M. Inverting this block diagonal
  // matrix and multiplying on the RHS by vector, r, is the result we want:

  // For now, restrict the distribution to M_PANEL-type:
  if ( r.isDistributed() && A->GetProcMapping() != M_PANEL )
  {
     cout << "PCPointJacobi::*: Invalid matrix distribution" << endl;
     exit(1);
  }
  if ( A->dim(2) < r.dim() )
  {
     cout << "PCPointJacobi::*: Incompatible matrix/vector" << endl;
     exit(1);
  }
  for ( i=0; i<(*sei1).szlocal(); i++ )
  {
     newr(i) = r(i) / ( (*A)(i,i+(*ri).beg())+TINY );
  }

  return newr;
#endif  

} // end of method oerator * (vector)



