//************************************************************************************//
// Module       : gttlist.cpp
// Date         : 8/9/02 (DLR)
// Copyright    : 2002-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                a simple template linked list of a template class.
//                This class was taken largely from Algorithms and Data Structures 
//                in C++ by Ameraal, although it has been recast as a template
//                class.
// Derived From : none.
// Modifications:
//************************************************************************************//
#include "gttlist.hpp"


//************************************************************************************
//************************************************************************************
// Constructor Method (1)
template<class TL,template<class> class TT> GTTList<TL,TT>::GTTList<TL,TT>(GBOOL renumber_on_delete)
:
nid                   (0),
num                   (0),
doRenumber            (renumber_on_delete),
pStart                (NULL),
pCurr                 (NULL),
pEnd                  (NULL)
{

} // end of constructor method (1)


//************************************************************************************
//************************************************************************************
// Constructor Method (2)
template<class TL,template<class> class TT> GTTList<TL,TT>::GTTList<TL,TT>(GINT  nelems, GBOOL renumber_on_delete)
:
nid                   (0),
num                   (0),
doRenumber            (renumber_on_delete),
pStart                (NULL),
pCurr                 (NULL),
pEnd                  (NULL)
{
  GINT  i;

  for ( i=0; i<nelems; i++ ) {
    add(NULL,TRUE);
  }

} // end of constructor method (2)


//************************************************************************************
//************************************************************************************
// Destructor
template<class TL,template<class> class TT> GTTList<TL,TT>::~GTTList<TL,TT>()
{
  empty();
}

//************************************************************************************
//************************************************************************************
// METHOD     : add (1)
// DESCRIPTION: 
// RETURNS    : add new structure to list
//************************************************************************************
template<class TL,template<class> class TT> void GTTList<TL,TT>::add()
{
  pCurr        = pEnd;
  pEnd         = new TTLinkElem;
  pEnd->member = new TT<TL> () ;
  pEnd->id     = nid;
  pEnd->cf     = TRUE;
  pEnd->next   = NULL;
  pEnd->prev   = pCurr;
  (pCurr ? pCurr->next : pStart) = pEnd;
//next();
  pCurr = pEnd;

  nid++;
  num++;
} // end of method add (1)


//************************************************************************************
//************************************************************************************
// METHOD     : add 
// DESCRIPTION: 
// RETURNS    : add new structure to list; provide option to delete
//************************************************************************************
template<class TL,template<class> class TT> void GTTList<TL,TT>::add(TT<TL> *m, GBOOL delete_here)
{
  pCurr        = pEnd;
  pEnd         = new TTLinkElem;
  pEnd->member = m ;
  pEnd->id     = nid;
  pEnd->cf     = delete_here;
  pEnd->next   = NULL;
  pEnd->prev   = pCurr;
  (pCurr ? pCurr->next : pStart) = pEnd;
//next();
  pCurr = pEnd;

  nid++;
  num++;
} // end of method add (2)


//************************************************************************************
//************************************************************************************
// METHOD     : add (3)
// DESCRIPTION:
// RETURNS    : add new structure to list
//************************************************************************************
template<class TL,template<class> class TT> void GTTList<TL,TT>::add(TL *m, GINT  n, GBOOL delete_here)
{
  pCurr        = pEnd;
  pEnd         = new TTLinkElem;
  pEnd->member = NULL;
  if ( m == NULL ) { pEnd->member = new TT<TL> (n); }
  else             { pEnd->member = new TT<TL> (m,n); }
  pEnd->id     = nid;
  pEnd->cf     = delete_here;
  pEnd->next   = NULL;
  pEnd->prev   = pCurr;
  (pCurr ? pCurr->next : pStart) = pEnd;
//next();
  pCurr = pEnd;

  nid++;
  num++;
} // end of method add (3)


//************************************************************************************
//************************************************************************************
// METHOD     : del (0)
// DESCRIPTION:
// RETURNS    : delete structure from list
//************************************************************************************
template<class TL,template<class> class TT> TT<TL> *GTTList<TL,TT>::del(TTLinkElem *e)
{
  TT<TL>     *m;
  TTLinkElem *next, *prev;

  if ( e == NULL ) {
    cout << "template<class TT> TT *GTTList<TT>::del (0) : attempting to delete a NULL list element" << endl;
    exit(1);
  }
  m    = e->member;
  prev = e->prev;
  next = e->next;
  
  if ( prev ) prev->next = next;
  if ( next ) next->prev = prev;
  if ( e->cf ) delete e->member;
  delete e;

//(pCurr ? pCurr->next : pStart) = pEnd;
//if ( pCurr  == e )  pCurr  = next ? next : pEnd;
  if ( pEnd   == e )  pEnd   = prev;
  if ( pCurr  == e )  pCurr  = next ? next : pEnd;
  if ( pStart == e )  pStart = next ? next : pCurr;


  num--;
  if ( num <= 0 ) {
    nid = 0;
  } 

  if ( doRenumber ) renumber();

  return m;
  
} // end of method del (0)


//************************************************************************************
//************************************************************************************
// METHOD     : del (1)
// DESCRIPTION:
// RETURNS    : delete structure from list
//************************************************************************************
template<class TL,template<class> class TT> TT<TL> *GTTList<TL,TT>::del(TT<TL> *m)
{
  TTLinkElem *e;

  if ( !(e=find(m)) ) return NULL;

  return del(e);
  
} // end of method del (1)


//************************************************************************************
//************************************************************************************
// METHOD     : del (2)
// DESCRIPTION:
// RETURNS    : delete structure from list
//************************************************************************************
template<class TL,template<class> class TT> TT<TL> *GTTList<TL,TT>::del(GINT  id)
{ 
//TT<TL>     *m;
  TTLinkElem *e;
  
  if ( !(e=find(id)) ) return NULL;
//m = e->member;
  
  return del(e);

} // end of method del (2)


//************************************************************************************
//************************************************************************************
// METHOD     : size
// DESCRIPTION:
// RETURNS    :  size of list
//************************************************************************************
template<class TL,template<class> class TT> GINT  GTTList<TL,TT>::size() 
{
  return num ;
} // end of method size

#if 0
//************************************************************************************
//************************************************************************************
// METHOD     : start
// DESCRIPTION:
// RETURNS    :
//************************************************************************************
template<class TL,template<class> class TT> void GTTList<TL,TT>::start(TTLinkElem *p)
{
  pCurr = ( p!=NULL ? p : pStart );
} // end of method start


//************************************************************************************
//************************************************************************************
// METHOD     : member (1)
// DESCRIPTION:
// RETURNS    :
//************************************************************************************
template<class TL,template<class> class TT> TT<TL> *GTTList<TL,TT>::member()
{
  return pCurr ? pCurr->member : NULL;
} // end of method member (1)


//************************************************************************************
//************************************************************************************
// METHOD     : member (2)
// DESCRIPTION:
// RETURNS    :
//************************************************************************************
template<class TL,template<class> class TT> TT<TL> *GTTList<TL,TT>::member(GINT  id)
{
  TTLinkElem *e;

  if ( (e=find(id)) == NULL ) return NULL;

  return e->member;
} // end of method member (2)


//************************************************************************************
//************************************************************************************
// METHOD     : next
// DESCRIPTION: 
// RETURNS    :  
//************************************************************************************
template<class TL,template<class> class TT> TTLinkElem *GTTList<TL,TT>::next()
{
  TTLinkElem *p = pCurr ? pCurr->next : NULL;
  pCurr = p;
  return pCurr;
} // end of method next
#endif

//************************************************************************************
//************************************************************************************
// METHOD     : curr
// DESCRIPTION:
// RETURNS    :
//************************************************************************************
template<class TL,template<class> class TT> TTLinkElem *GTTList<TL,TT>::curr()
{
  return pCurr;
} // end of method curr


#if 0
//************************************************************************************
//************************************************************************************
// METHOD     : find (1)
// DESCRIPTION: 
// RETURNS    : 
//************************************************************************************
template<class TL,template<class> class TT> TTLinkElem *GTTList<TL,TT>::find(GINT  id)
{

  TTLinkElem *p=pCurr;

  // check from current pointer first:
  if ( p && p->id == id ) return p;
  else if ( p && p->next && p->next->id == id ) {
    next();
    return p->next;
  }

  // start at beginning and search:
  start();
  while ( (p=curr()) != NULL ) {
    if ( p->id == id ) return p;
    next();
  }
  return NULL;

} // end of method find (1)


//************************************************************************************
//************************************************************************************
// METHOD     : find (2)
// DESCRIPTION: 
// RETURNS    : 
//************************************************************************************
template<class TL,template<class> class TT> TTLinkElem *GTTList<TL,TT>::find(TT<TL> *member)
{

  TTLinkElem *p=pCurr;

  // check from current pointer first:
  if ( p && p->member == member ) return p;
  else if ( p && p->next && p->next->member == member ) { 
     next();
     return p->next;
  }

  // start at beginning and search:
  start();
  while ( (p=curr()) != NULL ) {
    if ( p->member == member ) return p;
    next();
  }
  return NULL;

} // end of method find (2)


//************************************************************************************
//************************************************************************************
// METHOD     : operator() (1)
// DESCRIPTION: Member field access method
// ARGUMENTS  :
//
// RETURNS    :
//************************************************************************************
template<class TL,template<class> class TT> TL &GTTList<TL,TT>::operator()(const GINT  iElem, const GINT  i)
{
  TT<TL> *tt;

  if ( (tt=member(iElem)) == NULL )
  {
    cout << "GTTList::operator(): Cannot access element " << iElem << endl;
    exit(1);
  }

  return (*tt)(i) ;
  
} // end of method operator ()  (1)


//************************************************************************************
//************************************************************************************
// METHOD     : operator() (2)
// DESCRIPTION: Member field access method. May use this method to
//              set the value of a member pointer to outside pointer,
//              s.t. this object will not be deleted by the list. In
//              order for this to work , the ::add(TT<TL> *) method *only*
//              must be used when adding structures to the list.
// ARGUMENTS  :
//
// RETURNS    :
//************************************************************************************
template<class TL,template<class> class TT> TT<TL> *&GTTList<TL,TT>::operator()(const GINT  iElem)
{
  TTLinkElem  *tt;

  if ( (tt=find(iElem)) == NULL ) {
    cout << "GTTList::operator(): Cannot access element " << iElem << endl;
    exit(1);
  }

  return tt->member;
 
} // end of method operator () (2)


//************************************************************************************
//************************************************************************************
// METHOD     : operator[] (1)
// DESCRIPTION: Member field access method. May use this method to
//              set the value of a member pointer to outside pointer,
//              s.t. this object will not be deleted by the list. In
//              order for this to work , the ::add(TT<TL> *) method *only*
//              must be used when adding structures to the list.
// ARGUMENTS  :
//
// RETURNS    :
//************************************************************************************
template<class TL,template<class> class TT> TT<TL> *&GTTList<TL,TT>::operator[](const GINT  iElem)
{
  TTLinkElem *tt;

  if ( (tt=find(iElem)) == NULL ) {
    cout << "GTTList::operator[]: Cannot access element " << iElem << endl;
    exit(1);
  }

  return tt->member;

} // end of method operator [] (1)
#endif


//************************************************************************************
//************************************************************************************
// METHOD     : dim
// DESCRIPTION: Get dimension for member id iElem 
// ARGUMENTS  :
//
// RETURNS    :
//************************************************************************************
template<class TL,template<class> class TT> GINT  GTTList<TL,TT>::dim(const GINT  iElem)
{

    TT<TL> *tt;

  if ( (tt=member(iElem)) == NULL ) {
    cout << "GTTList::dim: Cannot access element " << iElem << endl;
    exit(1);
  }

  return tt->dim() ;

} // end of method dim


#if 0
//************************************************************************************
//************************************************************************************
// METHOD     :  << operator method (1)
// DESCRIPTION:
// ARGUMENTS  :
//
// RETURNS    :  
//************************************************************************************
template<class TL,template<class> class TT> ostream &operator<<(ostream &str, GTTList<TL,TT> &a)
{

  GINT  i=0;  

//if ( a == NULL ) return  str;

  str << endl;
  a.start(NULL);
  while ( a.member() && i < a.size() ) {
    str << "member[" << i << "]=" << *(a.member()) << endl;
    a.next();
    i++;
  }
  a.start(NULL);
    
  return str;
} // end of << operator(1)
#endif
  


#if 1
//************************************************************************************
//************************************************************************************
// METHOD     :  << operator method (1)
// DESCRIPTION: 
// ARGUMENTS  :
//
// RETURNS    :
//************************************************************************************
ostream &operator<<(ostream &str, GTTList<GDOUBLE,GBuffer> &a)
{

  GINT  i=0;

//if ( a == NULL ) return  str;

  str << endl;
  a.start(NULL);
  while ( a.member() && i < a.size() ) {
    str << "member[" << i << "]=" << *(a.member()) << endl;
    a.next();
    i++;
  }
  a.start(NULL);

  return str;
} // end of << operator(1)


//************************************************************************************
//************************************************************************************
// METHOD     :  << operator method (2)
// DESCRIPTION: 
// ARGUMENTS  :
//
// RETURNS    :
//************************************************************************************
ostream &operator<<(ostream &str, GTTList<GINT ,GBuffer> &a)
{

  GINT  i=0;

//if ( a == NULL ) return str;

  str << endl;
  a.start(NULL);
  while ( a.member() && i < a.size() ) {
    str << "member[" << i << "]=" << *(a.member()) << endl;
    a.next();
    i++;
  }
  a.start(NULL);

  return str;
} // end of << operator(2)


//************************************************************************************
//************************************************************************************
// METHOD     :  << operator method (3)
// DESCRIPTION: 
// ARGUMENTS  :
//
// RETURNS    :
//************************************************************************************
ostream &operator<<(ostream &str, GTTList<BDYTYPE,GBuffer> &a)
{

  GINT  i=0;

//if ( a == NULL ) return str;

  str << endl;
  a.start(NULL);
  while ( a.member() && i < a.size() ) {
    str << "member[" << i << "]=" << *(a.member()) << endl;
    a.next();
    i++;
  }
  a.start(NULL);

  return str;
} // end of << operator(3)


//************************************************************************************
//************************************************************************************
// METHOD     :  << operator method (4)
// DESCRIPTION: 
// ARGUMENTS  :
//
// RETURNS    :
//************************************************************************************
ostream &operator<<(ostream &str, GTTList<GDOUBLE ,GTVector> &a)
{

  GINT  i=0;

//if ( a == NULL ) return str;

  str << endl;
  a.start(NULL);
  while ( a.member() && i < a.size() ) {
    str << "member[" << i << "]=" << *(a.member()) << endl;
    a.next();
    i++;
  }
  a.start(NULL);

  return str;
} // end of << operator(4)
#endif


//************************************************************************************
//************************************************************************************
// METHOD     : renumber
// DESCRIPTION:
// RETURNS    : Renumber ids consecutively, used mainly after a delete
//************************************************************************************
template<class TL,template<class> class TT> GBOOL GTTList<TL,TT>::renumber()
{
  GINT      i=0;
  TTLinkElem *p, *pkeep=curr();

  start(NULL);
  while ( (p=curr()) != NULL ) {
    p->id = i;
    next();
    i++;
  }
  nid = i;
  start(NULL);
  return TRUE;
} // end of method renumber


//************************************************************************************
//************************************************************************************
// METHOD     : empty
// DESCRIPTION:
// ARGUMENTS  : 
// RETURNS    : delete list data
//************************************************************************************
template<class TL,template<class> class TT> void GTTList<TL,TT>::empty()
{
  TTLinkElem *dcurr, *dnext;

  dcurr = pStart;
  while ( dcurr ) {
    dnext = dcurr->next;
    del (dcurr);
    dcurr = dnext;
  }
  pStart = pEnd = pCurr = NULL;
  num = nid = 0;

} // end of method empty


//************************************************************************************
//************************************************************************************
// Assignment operator = method (1) 
template<class TL,template<class> class TT> void GTTList<TL,TT>::operator=(TL a)
{
  TTLinkElem *p, *pkeep=curr();
//TT<TL>     *m,

  start(NULL);
  while ( (p=curr()) != NULL ) {
    *(p->member) = a;
    next();
  }
//start(pkeep);
} // end = operator (1)


//************************************************************************************
//************************************************************************************
// Assignment operator = method (2) 
template<class TL,template<class> class TT> void GTTList<TL,TT>::operator=(GTTList<TL,TT> &v)
{
  TTLinkElem *pf, *pt, *pfkeep=curr(), *ptkeep=v.curr();
//TT<TL>     *m,

  if ( num != v.size() ) {
    cout << "GTTList<TL,TT>::operator=: incompatible lists" << endl;
    exit(1);
  }

  start(NULL);
  v.start(NULL);
  while ( (pt=curr()) != NULL && (pf=v.curr()) != NULL ) {
    *(pt->member) = *(pf->member);   // template class must have '=' operator
    next();
    v.next();
  }
//start(ptkeep);
//v.start(pfkeep);
} // end = operator (2)

