// Copyright (C) 2002 University Corporation for Atmospheric Research 
//       
// $Id: timer.cpp,v 1.8 2005/03/02 03:19:00 duaner Exp $
//

#include "timer.h"
//#if defined(MPI_GENERIC_DEFAULT)
#if 0
#  include "mpi.h"

double STK::Timer()
{
  return  (MPI_Wtime()*1.0e6);
}
#endif

#if defined(__hpux) 

#include <time.h>
#include <stdio.h>
#include <math.h>
double STK::Timer()  
{
  double t;
  struct timeval buffer;
  struct timezone dummy;
  gettimeofday (&buffer, &dummy);
  t = (double)(buffer.tv_sec*1000000 + buffer.tv_usec);
  return (t);
}

double STK::CTimer()  
{
  clock_t ct;
  double  t;
  ct = clock();
  t = (double)ct / ((double)CLOCKS_PER_SEC);

  return t;
}

#elif defined (__sun)  
#include <sys/time.h>
static int first_call = 1;
double STK::Timer() 
{
  hrtime_t nsec;
  /*  if (first_call) 
      {
      first_call = 0;
      init_ecache_();
      } 
  */
  nsec = gethrtime();
  return((double)nsec*1.0e-03);
}

double STK::CTimer()  
{
  clock_t ct;
  double  t;
  ct = clock();
  t = (double)ct / ((double)CLOCKS_PER_SEC);

  return t;
}
#elif defined(_LINUX) 
#include <time.h>
#include <sys/time.h>
double STK::Timer()
{
  double t;
  struct timeval buffer;
  struct timezone dummy;
  gettimeofday (&buffer, &dummy);
  t = (double)(buffer.tv_sec*1000000 + buffer.tv_usec);
  return (t);
}

double STK::CTimer()  
{
  clock_t ct;
  double  t;
  ct = clock();
  t = (double)ct / ((double)CLOCKS_PER_SEC);

  return t;
}
#elif defined(__alpha) 
#include <sys/time.h>
double STK::Timer()
{
  double t;
  struct timeval buffer;
  struct timezone dummy;
  gettimeofday (&buffer, &dummy);
  t = (double)(buffer.tv_sec*1000000+buffer.tv_usec);
  return (t);
}

double STK::CTimer()  
{
  clock_t ct;
  double  t;
  ct = clock();
  t = (double)ct / ((double)CLOCKS_PER_SEC);

  return t;
}
#elif defined(__sgi) 
#include <stdio.h>
#include <math.h>
#include <sys/time.h>
#include <sys/resource.h>
double STK::Timer()
{
  struct rusage rusage2;
  getrusage(RUSAGE_SELF, &rusage2);
  return( (double) (rusage2.ru_utime.tv_sec*1000000 +
		    rusage2.ru_utime.tv_usec  +
		    rusage2.ru_stime.tv_sec*1000000 +
		    rusage2.ru_stime.tv_usec));
}

double STK::CTimer()  
{
  clock_t ct;
  double  t;
  ct = clock();
  t = (double)ct / ((double)CLOCKS_PER_SEC);

  return t;
}
#elif defined(_AIX) 
#include <time.h>
#include <sys/time.h>
#include <sys/systemcfg.h>
double STK::Timer()
{
  double t;
  timebasestruct_t T;
  read_real_time(&T,TIMEBASE_SZ);
  time_base_to_time(&T,TIMEBASE_SZ);
  t=(double)(T.tb_low)*1.0e-03+(double)(T.tb_high)*1.0e+6;
  return (t);
}
double STK::CTimer()  
{
  clock_t ct;
  double  t;
  ct = clock();
  t = (double)ct / ((double)CLOCKS_PER_SEC);
  return t;
}
#elif defined(__APPLE__) && !defined(MPI_GENERIC_DEFAULT)
#include <sys/time.h>
double STK::Timer()
{
  double t;
  struct timeval buffer;
  struct timezone dummy;
  gettimeofday (&buffer, &dummy);
  t = (double)(buffer.tv_sec*1000000 + buffer.tv_usec);
  return (t);
}
double STK::CTimer()  
{
  clock_t ct;
  double  t;
  ct = clock();
  t = (double)ct / ((double)CLOCKS_PER_SEC);

  return t;
}
#else 
#include <time.h>
double STK::Timer(void)  
{
  clock_t t0;
  double c=1.0e+06/(double)CLOCKS_PER_SEC;
  double t;
  t=c*(double)clock();
  return(t);
}
double STK::CTimer()  
{
  clock_t ct;
  double  t;
  ct = clock();
  t = (double)ct / ((double)CLOCKS_PER_SEC);

  return t;
}
#endif
