#! /bin/tcsh
setenv HOME heat_test
setenv NPMIN  3
setenv NPMAX  11
setenv DELNP  2
setenv NR     2
setenv DOEQUIV no

#/bin/rm -r heat_conv_test1_na 
if ( $DOEQUIV == 'yes' ) then
  setenv PREFMESH ../../data/cone_mesh_16x16
  setenv PREFILEN {$HOME}_eq4x4nr2
  setenv NR       0
else
  setenv PREFMESH ../../data/cone_mesh_4x4
  setenv PREFILEN {$HOME}_nr{$NR}cf
endif
echo  making directory $HOME...
mkdir $HOME 
echo  copying data to directory $HOME...
cp gaspar_heat.dat $HOME/.
echo  changing to directory $HOME...
cd {$HOME}
@ I = $NPMIN
while ($I <= $NPMAX)
  setenv MESH {$PREFMESH}_n{$I}_p.dat
  setenv FILEN  {$PREFILEN}_n{$I}
  setenv LOGF log.{$FILEN}
  echo  making run directory $FILEN...
  mkdir {$FILEN}
  cp gaspar_heat.dat $FILEN/.
  echo  changing to directory $FILEN...
  cd {$FILEN}
  echo running {$FILEN} ...
#  echo MESH={$MESH}
#  echo LOGF={$LOGF}
if      ( $I == '3' ) then
  setenv DT 2.44141e-3
else if ( $I == '5' ) then 
  setenv DT 2.911721e-4
else if ( $I == '7' ) then 
  setenv DT 7.037091e-5
else if ( $I == '9' ) then 
  setenv DT 2.45324e-5
else if ( $I == '11' ) then 
  setenv DT 1.06343e-5
endif

   setenv CALL "../../../bin/gaspar -if gaspar_heat.dat -dt $DT -time 0.5 -nr $NR -m $MESH -of $FILEN -lf $LOGF "
   echo running:  $CALL
   $CALL >&! err{$I}
  echo $CALL ......... done.
  @ I = $I + $DELNP
  cd ..
end
cd ..

