"make.lle" <-
function (jac, nprod, statevector = FALSE, verbose=verbose)
{
    nc <- ncol(jac)
    n<- nrow( jac)
    if (statevector) {
        state <- 1
        emd <- sqrt(nc)
        test <- emd - round(emd)
        if (test != 0) 
            cat("Stop, no. of col of jac is not a perfect \nsquare", 
                fill = TRUE)
    }
    else {
        state <- 0
        emd <- nc
    }

    if( nprod<0) nprod<- n 

    ldder<- nc
    nll= n-nprod+1
 out<-.Fortran( "llest", 
                  nlags= as.integer( emd), 
                  ldder= as.integer( ldder),
                  der= as.double(t(jac)),
                  n= as.integer(n),
                  nprod=as.integer(nprod),
                  nll=as.integer(0),
                  llesv=as.double(rep(0,ldder*nll)), 
                  lleqr=as.double(rep(0,ldder*nll)),
                  lle11= as.double(rep(0,nll)),
                  state=as.integer(state)
               )
cbind(
matrix( out$llesv, ldder,nll)[1,],   
matrix( out$lleqr, ldder,nll)[1,],
 out$lle11
)
    
}
