\name{nlar}
\alias{nlar}
\title{
  Nonlinear autoregressive model 
}
\description{
Fits a nonlinear autoregressive model to time series data using  
a specific regression.  
}
\usage{
nlar(Y, lags, cov=NA, method="nnreg", ...)
}
\arguments{
\item{Y}{
The time series 
}
\item{lags}{
A vector that specifies which lags of Y to use in  the autoregressive function 
}
\item{cov}{
A vector or matrix of covariates as long as the Y series these are 
additional variables that will be used in the regression function 
}
\item{method}{
Name of R function to fit the nonparametric model e.g. nnreg Tps 
The calling arguments to the method are assumed to be x and y for the 
usual kind of regression  y = f(x) + noise. 
e.g. nnreg( x,y)
}
\item{\dots}{
Optional argument that as passed through to the regression method. 
e.g. k1 and k2 the ragnes of hidden units in the nnreg method.
}
}
\value{
An object of class nlar 
}
\details{
his function fits a model of the form: 
 Y.t =  f( Y.(t-l1),...,Y.(t-ld),S.t) + e.t 
Where e.t is assumed to mean zero, uncorrelated errors. Such a form is 
useful for testing whether a system is chaotic. 
}
\seealso{
lle, predict.nlar  
}
\examples{
# Fit the rossler series. A toy dynamical system that is chaotic 
# Use a neural network with 4 hidden units based on lags 1, 2 and 3 of 
# the series.  
nlar( rossler,lags=c(1,2,3), method="nnreg",k1=4)-> out 
summary(out) 
plot( out) 
lle( out) # calculate local and global Lyapunov exponents 
}
\keyword{ts}
% docclass is function
% Converted by Sd2Rd version 1.21.
