\name{lle}
\alias{lle.default}
\alias{lle}
\title{
  Calculates local Lyapunov exponents for plotting. 
}
\description{
This function calculates local and global Lyapunov exponents from a 
fit to a nonlinear model or a Jacobian matrix. It creates a structure 
that can plotted with a series of boxplots. 
}
\usage{
lle( x,...) 

lle.default(jac, lags=NA,  nprod=c(5, 10, 20, 40, 80), skip, 
statevector=F, verbose=F)
}
\arguments{
\item{x} {
A fitted object supported by this method or a matrix ( e.g. jac below)
}
\item{\dots}{
Other arguments depending on the type of the object x}

\item{jac}{
Jacobian matrix or a nnreg fit. 
}
\item{nprod}{
Vector of sizes of LLE products to calculate. 
}
\item{skip}{
Columns of Jacobian matrix to skip in calculating LLEs. 
For example, skip the columns associated with forcing functions. 
}
\item{statevector}{
If false, a time-delay reconstruction model is assumed and a Jacobian matrix 
n by d is expected, where n is the length of the time series and d is the 
dimension of the state space.  (See details below.)
If true, a state space vector model is assumed and a Jacobian matrix n by 
d**2  
is expected. 
}
\item{lags}{
Lagged time values used in the Jacobian matrix. 
}
\item{verbose}{
If true prints out intermediate information for testing and 
debugging. 
}
}
\value{

\item{local}{
Matrix of LLEs with columns corresponding to the LLEs of the nprod values. 
}
\item{nprod}{
Vector of LLE products of Jacobians. 
}
\item{glb}{
Global Lyapunov exponent. 
}

}
\section{Details} 
This function handles two different of representing a nonlinear 
autoregressive map. 

 Given the univariate series say X.t  then 
X.t can be considered a nonlinear function of past lags of X:

X.t+1 = G( X.t, X.t-1, ..., X,t-d) + e.t

In this form lags of X stand in for unobserved state variables at time t. 
The basic rationale for this form comes from Taken's embedding theorem 
that guarantees that a g exists under the no noise case and based on 
assumptions on the attractor dimension and the number of lags used of X. 
Although express as a univariate model the state vector in this case is 
consists of the "delay" coordinates Z.t=(X.t, X.t-1, ..., X,t-d) and at 
time t+1 Z.t+1 has the nonlinear map applied to give the first element but 
the remaining components are found by simply shifting those in Z.t over 
one place. This particular structure needs to be taken in to account when 
finding the Jacobian of the map from Z.t to Z.t+1 as many elements are 
either zero or unity. In fact only the d partial derivatives of g need be 
passed to this function. 

The more general form is just a d dimensional map that takes Z.t into
Z.t+1. We refer to this as the state vector form because one is presumably
working with a full state vector rather one constructed from delay
coordinates.  In this case all the Jacobian elements may be nonzero and so
d**2 total partial derivatives must be supplied.

To see how the two forms are indexed see the example below.

\section{References}{
S. Ellner, D.W. Nychka, and A.R. Gallant. 1992.  LENNS,  a 
program  to  estimate  the  dominant  Lyapunov exponent of 
noisy nonlinear systems from time series  data.  Institute 
of  Statistics  Mimeo Series No. 2235, Statistics Department, 
North Carolina State University, Raleigh, NC 27695-8203. 
}
\seealso{
make.lle, nlar, lle.nlar  
}
\examples{
make.lags(rossler[1:200],c(1,2,3)) -> data  # create 
# 3-d time delay vector model of the x variable of rossler system. 
nnreg(data$x,data$y,5,5) -> fit # fit time series model using nnreg. 
jac<- predict(fit, derivative=1)  
lle( jac, lags= c(1,2,3))-> rossler.lle  # LLEs of Rossler data 
summary(rossler.lle) 
plot(rossler.lle)  # plot LLEs 
# here is an easier way 
nlar( rossler[1:200], lags=1:3, method="nnreg", k1=5)-> out 
lle( out) -> rossler.lle 

# here is an example that does not assume the delay coordinate form.
# the rossler is actually defined by a 3 dimensional state vector
# we estimate the full 3-d map and then estimate the full 3X3 
# matrix of partials 
#
y<- rossler.state[2:201,]
x<- rossler.state[1:200,]
nnreg(x,y[,1],5,5)-> X.fit
nnreg(x,y[,2],5,5)-> Y.fit
nnreg(x,y[,3],5,5)-> Z.fit
#
# Note that the partials are just bound as columns. Yes this confusing 
# but it made for the easiest modification of the FORTRAN. 
# jac[k,] will have 9 ( 3**2) elements and the matrix
# matrix( jac[k,], byrow=TRUE)=G should be the linear approximation to the 
# nonlinear map.  e.g. Z.t+1 - Z'.t+1  ~=  G Z.t - Z'.t
#
jac<- cbind( 
predict( X.fit, derivative=1),
predict( Y.fit, derivative=1),
predict( Z.fit, derivative=1))

lle( jac, statevector=TRUE)-> test.lle

summary( test.lle)

# there is some difference between delay coordinates and state coordinates 
# and only in the limit will the  global Lyapunov exponent will be the 
# same for both representations. 



}
\keyword{ts}
% docclass is function
% Converted by Sd2Rd version 1.21.
