\name{lle.nlar}
\alias{lle.nlar}
\title{
  Calculates local Lyapunov exponents from an nonlinear autoregressive 
model fit.
}
\description{
This function calculates local and global Lyapunov exponents from a 
fit to a nonlinear autoregressive model.
It creates a 
structure that can plotted with a series of boxplots or summarized.  
}
\usage{
lle.nlar(obj, model=NA,  nprod=c(5, 10, 20, 40, 80), verbose=F, \dots )
}
\arguments{
\item{obj} {
A fitted object from the nlar function
}
\item{model}{
Particular model to use if more than one is fit in obj. 
}
\item{nprod}{
Sizes of products to evaluate.}
\item{verbose}{
If true prints intermediate information for debugging}
\item{\dots}{
Any other arguments to be passed to the predict function 
evaluating the fitted autoregressive map.}
}

\value{

\item{local}{
Matrix of LLEs with columns corresponding to the LLEs of the nprod values. 
}
\item{nprod}{
Vector of LLE products of Jacobians. 
}
\item{glb}{
Global Lyapunov exponent. 
}

}
\section{References}{
S. Ellner, D.W. Nychka, and A.R. Gallant. 1992.  LENNS,  a 
program  to  estimate  the  dominant  Lyapunov exponent of 
noisy nonlinear systems from time series  data.  Institute 
of  Statistics  Mimeo Series No 2235, Statistics Department, 
North Carolina State University, Raleigh, NC 27695-8203. 
}
\seealso{
make.lle, nlar, plot.lle, print.lle  
}
\examples{

nlar( rossler[1:200], lags=1:3, method="nnreg", k1=5)-> out 

lle( out) -> rossler.lle 

summary( rossler.lle)

}
\keyword{ts}
% docclass is function
% Converted by Sd2Rd version 1.21.
