\name{plot.lle}
\alias{plot.lle}
\title{
  Plots local Lyapunov exponents 
}
\description{
Series of boxplots of local Lyapunov exponents (LLE) from the lle object. 
This plot illustrates the dependence of the distribution of the LLE's as a 
function of product size.
}
\usage{
plot.lle(out,type="qr",...)
}
\arguments{
\item{out}{
An object from the lle function. 
}
\item{type}{
Type of LLE estimate. Choices are "qr", "svd", "11". See the help file for 
lle for more details on these estimates. 
}
\item{\dots}{
Any graphical parameters to be passed to the main plot}

}

\value{
Plots  boxplots of qr type LLEs  at the size of their products. 
The horizontal line is the estimated global Lypunov exponent. 
}
\section{References}{
S. Ellner, D.W. Nychka, and A.R. Gallant. 1992.  LENNS,  a 
program  to  estimate  the  dominant  Lyapunov exponent of 
noisy nonlinear systems from time series  data.  Institute 
of  Statistics  Mimeo Series 2235, Statistics Department, 
North Carolina State University, Raleigh, NC 27695-8203. 
}
\seealso{
make.lle, lle, bplot  
}
\examples{
 make.lags(rossler.state[1:200,1],c(1,2,3)) -> data
# create 3-d time delay vector model of the x variable of rossler system.
 nnreg(data$x,data$y,5,5) -> rossler.fit

lle(predict(rossler.fit, derivative=1)) -> rossler.lle  # LLEs of Rossler data 

plot(rossler.lle)  # plot LLEs 

}
\keyword{hplot}
