\name{summary.lle}
\alias{summary.lle}
\title{
  Prints  summary statistics of  local Lyapunov exponents 
}
\description{
Reports summary statistics that in dicate the distribution of local 
lyapunov exponents for different product lengths. 
}
\usage{
summary.lle(obj,digits= 5, type="qr")
}
\arguments{
\item{obj}{
An object from the lle function. 
}
\item{digits}{
Number of significant digits in summary.
}
\item{type}{
Type of LLE estimate. Choices are "qr", "svd", "11". See the help file for 
lle for more details on these estimates. 
}
}
\value{
A matrix with the statistics as columns and the rows are different product 
lengths. 
}
\seealso{
make.lle, lle, print.lle, lle.nlar
}
\examples{

make.lags(rossler[1:200],c(1,2,3)) -> data 
nnreg(data$x,data$y,5,5) -> rossler.fit
lle(predict(rossler.fit, derivative=1)) -> rossler.lle 


print(rossler.lle)  # plot LLEs 

# or just
rossler.lle

}
\keyword{ts}
% docclass is function
% Converted by Sd2Rd version 1.21.
