library(ncdf4)

# convert netcdf files to plain text so we can read them easily into R
# using read.table.

for (m in c("obs","cur","fut")){

  data = list()

  for (v in c("tmax","tmin","prec")){

    infile = paste(v,m,"75.30.nc",sep=".")
    fin = nc_open(infile)
    data[[v]] = c(ncvar_get(fin,v))
  }
  data[["tmed"]] = (data[["tmax"]] + data[["tmin"]] )/2  
  data[["dtr2"]] =  data[["tmax"]] - data[["tmin"]]

  time = c(ncvar_get(fin,"time"))

  basetime = ncatt_get(fin,"time","units")$value
  basetime = sub("days since ","",basetime)
  basetime = as.Date(basetime)

  time = basetime + time

  write.table(data,paste0("../",m,".txt"),row.names=time)
}


# Copyright 2014 Univ. Corp for Atmos. Research
# Author: Seth McGinnis, mcginnis@ucar.edu
